/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.misc.IOUtils;
import com.j256.ormlite.support.DatabaseResults;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;

public class JdbcDatabaseResults
implements DatabaseResults {
    private final PreparedStatement preparedStmt;
    private final ResultSet resultSet;
    private final ResultSetMetaData metaData;
    private final ObjectCache objectCache;
    private final boolean cacheStore;
    private boolean first = true;

    public JdbcDatabaseResults(PreparedStatement preparedStmt, ResultSet resultSet, ObjectCache objectCache, boolean cacheStore) throws SQLException {
        this.preparedStmt = preparedStmt;
        this.resultSet = resultSet;
        this.metaData = resultSet.getMetaData();
        this.objectCache = objectCache;
        this.cacheStore = cacheStore;
    }

    public int getColumnCount() throws SQLException {
        return this.metaData.getColumnCount();
    }

    public String[] getColumnNames() throws SQLException {
        int colN = this.metaData.getColumnCount();
        String[] columnNames = new String[colN];
        for (int colC = 0; colC < colN; ++colC) {
            columnNames[colC] = this.metaData.getColumnLabel(colC + 1);
        }
        return columnNames;
    }

    public boolean first() throws SQLException {
        if (this.first) {
            this.first = false;
            return this.next();
        }
        return this.resultSet.first();
    }

    public boolean next() throws SQLException {
        if (this.resultSet.next()) {
            return true;
        }
        if (!this.preparedStmt.getMoreResults()) {
            return false;
        }
        return this.resultSet.next();
    }

    public boolean last() throws SQLException {
        return this.resultSet.last();
    }

    public boolean previous() throws SQLException {
        return this.resultSet.previous();
    }

    public boolean moveRelative(int offset) throws SQLException {
        return this.resultSet.relative(offset);
    }

    public boolean moveAbsolute(int position) throws SQLException {
        return this.resultSet.absolute(position);
    }

    public int findColumn(String columnName) throws SQLException {
        return this.resultSet.findColumn(columnName) - 1;
    }

    public InputStream getBlobStream(int columnIndex) throws SQLException {
        Blob blob = this.resultSet.getBlob(columnIndex + 1);
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.resultSet.getBoolean(columnIndex + 1);
    }

    public char getChar(int columnIndex) throws SQLException {
        String string = this.resultSet.getString(columnIndex + 1);
        if (string == null || string.length() == 0) {
            return '\u0000';
        }
        if (string.length() == 1) {
            return string.charAt(0);
        }
        throw new SQLException("More than 1 character stored in database column: " + columnIndex);
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.resultSet.getByte(columnIndex + 1);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.resultSet.getBytes(columnIndex + 1);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.resultSet.getDouble(columnIndex + 1);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.resultSet.getFloat(columnIndex + 1);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.resultSet.getInt(columnIndex + 1);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.resultSet.getLong(columnIndex + 1);
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.resultSet.getShort(columnIndex + 1);
    }

    public String getString(int columnIndex) throws SQLException {
        return this.resultSet.getString(columnIndex + 1);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.resultSet.getTimestamp(columnIndex + 1);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.resultSet.getBigDecimal(columnIndex + 1);
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.resultSet.getObject(columnIndex + 1);
    }

    public boolean wasNull(int columnIndex) throws SQLException {
        return this.resultSet.wasNull();
    }

    public ObjectCache getObjectCacheForRetrieve() {
        return this.objectCache;
    }

    public ObjectCache getObjectCacheForStore() {
        if (this.cacheStore) {
            return this.objectCache;
        }
        return null;
    }

    public void close() throws IOException {
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            throw new IOException("could not close result set", e);
        }
    }

    public void closeQuietly() {
        IOUtils.closeQuietly((Closeable)((Object)this));
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

