/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.field.FieldType;
import java.util.List;

public class MysqlDatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "mysql";
    private static final String DRIVER_CLASS_NAME_OLD = "com.mysql.jdbc.Driver";
    private static final String DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String DATABASE_NAME = "MySQL";
    public static final String DEFAULT_CREATE_TABLE_SUFFIX = "ENGINE=InnoDB";
    private String createTableSuffix = "ENGINE=InnoDB";

    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    protected String[] getDriverClassNames() {
        return new String[]{DRIVER_CLASS_NAME, DRIVER_CLASS_NAME_OLD};
    }

    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    public void setCreateTableSuffix(String createTableSuffix) {
        this.createTableSuffix = createTableSuffix;
    }

    protected void appendDateType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("DATETIME");
    }

    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("TINYINT(1)");
    }

    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("AUTO_INCREMENT ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    public void appendCreateTableSuffix(StringBuilder sb) {
        sb.append(this.createTableSuffix);
        sb.append(' ');
    }

    public boolean isTruncateSupported() {
        return true;
    }

    public boolean isCreateIfNotExistsSupported() {
        return true;
    }

    public boolean isCreateIndexIfNotExistsSupported() {
        return false;
    }

    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        super.appendByteArrayType(sb, fieldType, fieldWidth);
    }

    protected void appendLongStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        super.appendLongStringType(sb, fieldType, fieldWidth);
    }
}

