/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.query.And;
import com.j256.ormlite.stmt.query.Between;
import com.j256.ormlite.stmt.query.Clause;
import com.j256.ormlite.stmt.query.Eq;
import com.j256.ormlite.stmt.query.Ge;
import com.j256.ormlite.stmt.query.Gt;
import com.j256.ormlite.stmt.query.In;
import com.j256.ormlite.stmt.query.IsNotNull;
import com.j256.ormlite.stmt.query.IsNull;
import com.j256.ormlite.stmt.query.Le;
import com.j256.ormlite.stmt.query.Like;
import com.j256.ormlite.stmt.query.Lt;
import com.j256.ormlite.stmt.query.Ne;
import com.j256.ormlite.stmt.query.NeedsFutureClause;
import com.j256.ormlite.stmt.query.Not;
import com.j256.ormlite.stmt.query.Or;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Where<T, ID> {
    private final TableInfo<T> tableInfo;
    private final StatementBuilder<T, ID> statementBuilder;
    private SimpleStack<Clause> clauseList = new SimpleStack();
    private NeedsFutureClause needsFuture = null;

    Where(TableInfo<T> tableInfo, StatementBuilder<T, ID> statementBuilder) {
        this.tableInfo = tableInfo;
        this.statementBuilder = statementBuilder;
    }

    public Where<T, ID> and() {
        this.addNeedsFuture(new And(this.removeLastClause("AND")));
        return this;
    }

    public Where<T, ID> and(Where<T, ID> left, Where<T, ID> right) {
        Clause rightClause = this.removeLastClause("AND");
        Clause leftClause = this.removeLastClause("AND");
        this.addClause(new And(leftClause, rightClause));
        return this;
    }

    public Where<T, ID> between(String columnName, Object low, Object high) throws SQLException {
        this.addClause(new Between(columnName, this.findColumnFieldType(columnName), low, high));
        return this;
    }

    public Where<T, ID> eq(String columnName, Object value) throws SQLException {
        this.addClause(new Eq(columnName, this.findColumnFieldType(columnName), value));
        return this;
    }

    public Where<T, ID> ge(String columnName, Object value) throws SQLException {
        this.addClause(new Ge(columnName, this.findColumnFieldType(columnName), value));
        return this;
    }

    public Where<T, ID> gt(String columnName, Object value) throws SQLException {
        this.addClause(new Gt(columnName, this.findColumnFieldType(columnName), value));
        return this;
    }

    public Where<T, ID> in(String columnName, Iterable<?> objects) throws SQLException {
        this.addClause(new In(columnName, this.findColumnFieldType(columnName), objects));
        return this;
    }

    public Where<T, ID> in(String columnName, Object ... objects) throws SQLException {
        if (objects.length == 1 && objects[0].getClass().isArray()) {
            throw new IllegalArgumentException("in(Object... objects) seems to be an array within an array");
        }
        this.addClause(new In(columnName, this.findColumnFieldType(columnName), objects));
        return this;
    }

    public Where<T, ID> isNull(String columnName) throws SQLException {
        this.addClause(new IsNull(columnName, this.findColumnFieldType(columnName)));
        return this;
    }

    public Where<T, ID> isNotNull(String columnName) throws SQLException {
        this.addClause(new IsNotNull(columnName, this.findColumnFieldType(columnName)));
        return this;
    }

    public Where<T, ID> le(String columnName, Object value) throws SQLException {
        this.addClause(new Le(columnName, this.findColumnFieldType(columnName), value));
        return this;
    }

    public Where<T, ID> lt(String columnName, Object value) throws SQLException {
        this.addClause(new Lt(columnName, this.findColumnFieldType(columnName), value));
        return this;
    }

    public Where<T, ID> like(String columnName, Object value) throws SQLException {
        this.addClause(new Like(columnName, this.findColumnFieldType(columnName), value));
        return this;
    }

    public Where<T, ID> ne(String columnName, Object value) throws SQLException {
        this.addClause(new Ne(columnName, this.findColumnFieldType(columnName), value));
        return this;
    }

    public Where<T, ID> not() {
        this.addNeedsFuture(new Not());
        return this;
    }

    public Where<T, ID> not(Where<T, ID> comparison) {
        this.addClause(new Not(this.removeLastClause("NOT")));
        return this;
    }

    public Where<T, ID> or() {
        this.addNeedsFuture(new Or(this.removeLastClause("OR")));
        return this;
    }

    public Where<T, ID> or(Where<T, ID> left, Where<T, ID> right) {
        Clause rightClause = this.removeLastClause("OR");
        Clause leftClause = this.removeLastClause("OR");
        this.addClause(new Or(leftClause, rightClause));
        return this;
    }

    public PreparedQuery<T> prepare() throws SQLException {
        return this.statementBuilder.prepareStatement();
    }

    void appendSql(DatabaseType databaseType, StringBuilder sb, List<SelectArg> columnArgList) throws SQLException {
        if (this.clauseList.isEmpty()) {
            throw new IllegalStateException("No where clauses defined.  Did you miss a where operation?");
        }
        if (this.clauseList.size() != 1) {
            throw new IllegalStateException("Both the \"left-hand\" and \"right-hand\" clauses have been defined.  Did you miss an AND or OR?");
        }
        this.clauseList.peek().appendSql(databaseType, sb, columnArgList);
    }

    private void addNeedsFuture(NeedsFutureClause needsFuture) {
        if (this.needsFuture != null) {
            throw new IllegalStateException(this.needsFuture + " is already waiting for a future clause, can't add: " + needsFuture);
        }
        this.needsFuture = needsFuture;
        this.addClause(needsFuture);
    }

    private void addClause(Clause clause) {
        if (this.needsFuture == null || clause == this.needsFuture) {
            this.clauseList.push(clause);
        } else {
            this.needsFuture.setMissingClause(clause);
            this.needsFuture = null;
        }
    }

    private Clause removeLastClause(String label) {
        if (this.clauseList.isEmpty()) {
            throw new IllegalStateException("Expecting there to be a clause already defined for '" + label + "' operation");
        }
        return this.clauseList.pop();
    }

    public String toString() {
        if (this.clauseList.isEmpty()) {
            return "empty where clause";
        }
        Clause clause = this.clauseList.peek();
        return "where clause: " + clause;
    }

    private FieldType findColumnFieldType(String columnName) throws SQLException {
        return this.tableInfo.getFieldTypeByColumnName(columnName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleStack<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = -8116427380277806666L;

        private SimpleStack() {
        }

        public void push(E obj) {
            this.add(obj);
        }

        public E pop() {
            return this.remove(this.size() - 1);
        }

        public E peek() {
            return this.get(this.size() - 1);
        }
    }
}

