/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Db2DatabaseType
extends BaseDatabaseType
implements DatabaseType {
    private static final String DATABASE_URL_PORTION = "db2";
    private static final String DRIVER_CLASS_NAME = "COM.ibm.db2.jdbc.app.DB2Driver";

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    @Override
    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    protected void appendBooleanType(StringBuilder sb) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendByteType(StringBuilder sb) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendObjectType(StringBuilder sb) {
        sb.append("VARCHAR [] FOR BIT DATA");
    }

    @Override
    protected void configureGeneratedId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("GENERATED ALWAYS AS IDENTITY ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String word) {
        sb.append('\"').append(word).append('\"');
    }

    @Override
    protected void appendUnique(StringBuilder sb, FieldType fieldType, List<String> statementsAfter) {
        StringBuilder alterSb = new StringBuilder();
        alterSb.append("ALTER TABLE ");
        this.appendEscapedEntityName(alterSb, fieldType.getTableName());
        alterSb.append(" ADD UNIQUE (");
        this.appendEscapedEntityName(alterSb, fieldType.getDbColumnName());
        alterSb.append(");");
        statementsAfter.add(alterSb.toString());
    }
}

