/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMappedStatement<T> {
    protected static Logger logger = LoggerFactory.getLogger(BaseMappedStatement.class);
    protected final TableInfo<T> tableInfo;
    protected final FieldType idField;
    protected final String statement;
    protected final FieldType[] argFieldTypes;
    protected final SqlType[] argSqlTypes;

    protected BaseMappedStatement(TableInfo<T> tableInfo, String statement, List<FieldType> argFieldTypeList) {
        this.tableInfo = tableInfo;
        this.idField = tableInfo.getIdField();
        this.statement = statement;
        this.argFieldTypes = argFieldTypeList.toArray(new FieldType[argFieldTypeList.size()]);
        this.argSqlTypes = this.getSqlTypes(this.argFieldTypes);
    }

    protected int insert(DatabaseConnection databaseConnection, T data) throws SQLException {
        try {
            Object[] args = this.getFieldObjects(this.argFieldTypes, data);
            int rowC = databaseConnection.insert(this.statement, args, this.argSqlTypes);
            logger.debug("insert data with statement '{}' and {} args, changed {} rows", this.statement, args.length, rowC);
            if (args.length > 0) {
                logger.trace("insert arguments: {}", new Object[]{args});
            }
            return rowC;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Unable to run insert stmt on object " + data + ": " + this.statement, e);
        }
    }

    public int update(DatabaseConnection databaseConnection, T data) throws SQLException {
        try {
            Object[] args = this.getFieldObjects(this.argFieldTypes, data);
            int rowC = databaseConnection.update(this.statement, args, this.argSqlTypes);
            logger.debug("update data with statement '{}' and {} args, changed {} rows", this.statement, args.length, rowC);
            if (args.length > 0) {
                logger.trace("update arguments: {}", new Object[]{args});
            }
            return rowC;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Unable to run update stmt on object " + data + ": " + this.statement, e);
        }
    }

    public int delete(DatabaseConnection databaseConnection, T data) throws SQLException {
        try {
            Object[] args = this.getFieldObjects(this.argFieldTypes, data);
            int rowC = databaseConnection.delete(this.statement, args, this.argSqlTypes);
            logger.debug("delete data with statement '{}' and {} args, changed {} rows", this.statement, args.length, rowC);
            if (args.length > 0) {
                logger.trace("delete arguments: {}", new Object[]{args});
            }
            return rowC;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Unable to run delete stmt on object " + data + ": " + this.statement, e);
        }
    }

    protected Object[] getFieldObjects(FieldType[] fieldTypes, Object data) throws SQLException {
        Object[] objects = new Object[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            FieldType fieldType = fieldTypes[i];
            objects[i] = fieldType.extractJavaFieldToSqlArgValue(data);
            if (objects[i] != null || fieldType.getDefaultValue() == null) continue;
            objects[i] = fieldType.getDefaultValue();
        }
        return objects;
    }

    static void appendWhereId(DatabaseType databaseType, FieldType idField, StringBuilder sb, List<FieldType> fieldTypeList) {
        sb.append("WHERE ");
        BaseMappedStatement.appendFieldColumnName(databaseType, sb, idField, fieldTypeList);
        sb.append("= ?");
    }

    static void appendTableName(DatabaseType databaseType, StringBuilder sb, String prefix, String tableName) {
        if (prefix != null) {
            sb.append(prefix);
        }
        databaseType.appendEscapedEntityName(sb, tableName);
        sb.append(' ');
    }

    static void appendFieldColumnName(DatabaseType databaseType, StringBuilder sb, FieldType fieldType, List<FieldType> fieldTypeList) {
        databaseType.appendEscapedEntityName(sb, fieldType.getDbColumnName());
        if (fieldTypeList != null) {
            fieldTypeList.add(fieldType);
        }
        sb.append(' ');
    }

    private SqlType[] getSqlTypes(FieldType[] fieldTypes) {
        SqlType[] typeVals = new SqlType[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            typeVals[i] = fieldTypes[i].getSqlTypeVal();
        }
        return typeVals;
    }

    public String toString() {
        return "MappedStatement: " + this.statement;
    }
}

