/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.query.OrderBy;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilder<T, ID>
extends StatementBuilder<T, ID> {
    private boolean distinct = false;
    private boolean selectIdColumn = true;
    private final FieldType idField;
    private List<String> selectColumnList = null;
    private List<OrderBy> orderByList = null;
    private List<String> groupByList = null;

    public QueryBuilder(DatabaseType databaseType, TableInfo<T> tableInfo) {
        super(databaseType, tableInfo, StatementBuilder.StatementType.SELECT);
        this.idField = tableInfo.getIdField();
    }

    public PreparedQuery<T> prepare() throws SQLException {
        return super.prepareStatement();
    }

    @Deprecated
    public StatementBuilder<T, ID> columns(String ... columns) {
        return this.selectColumns(columns);
    }

    @Deprecated
    public StatementBuilder<T, ID> columns(Iterable<String> columns) {
        return this.selectColumns(columns);
    }

    public QueryBuilder<T, ID> selectColumns(String ... columns) {
        if (this.selectColumnList == null) {
            this.selectColumnList = new ArrayList<String>();
        }
        for (String column : columns) {
            this.addSelectColumnToList(column);
        }
        return this;
    }

    public QueryBuilder<T, ID> selectColumns(Iterable<String> columns) {
        if (this.selectColumnList == null) {
            this.selectColumnList = new ArrayList<String>();
        }
        for (String column : columns) {
            this.addSelectColumnToList(column);
        }
        return this;
    }

    public QueryBuilder<T, ID> groupBy(String columnName) {
        this.verifyColumnName(columnName);
        if (this.groupByList == null) {
            this.groupByList = new ArrayList<String>();
        }
        this.groupByList.add(columnName);
        this.selectIdColumn = false;
        return this;
    }

    public QueryBuilder<T, ID> orderBy(String columnName, boolean ascending) {
        this.verifyColumnName(columnName);
        if (this.orderByList == null) {
            this.orderByList = new ArrayList<OrderBy>();
        }
        this.orderByList.add(new OrderBy(columnName, ascending));
        return this;
    }

    public QueryBuilder<T, ID> distinct() {
        this.distinct = true;
        this.selectIdColumn = false;
        return this;
    }

    public QueryBuilder<T, ID> limit(Integer maxRows) {
        this.limit = maxRows;
        return this;
    }

    @Override
    protected void appendStatementStart(StringBuilder sb, List<FieldType> resultFieldTypeList) throws SQLException {
        sb.append("SELECT ");
        if (this.databaseType.isLimitAfterSelect()) {
            this.appendLimit(sb);
        }
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        this.appendColumns(sb, resultFieldTypeList);
        sb.append("FROM ");
        this.databaseType.appendEscapedEntityName(sb, this.tableInfo.getTableName());
        sb.append(' ');
    }

    @Override
    protected void appendStatementEnd(StringBuilder sb) {
        this.appendGroupBys(sb);
        this.appendOrderBys(sb);
        if (!this.databaseType.isLimitAfterSelect()) {
            this.appendLimit(sb);
        }
    }

    private void addSelectColumnToList(String column) {
        this.verifyColumnName(column);
        this.selectColumnList.add(column);
    }

    private void appendColumns(StringBuilder sb, List<FieldType> fieldTypeList) {
        if (this.selectColumnList == null) {
            sb.append("* ");
            for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
                fieldTypeList.add(fieldType);
            }
            return;
        }
        boolean first = true;
        boolean hasId = false;
        for (String columnName : this.selectColumnList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            FieldType fieldType = this.tableInfo.getFieldTypeByColumnName(columnName);
            this.appendFieldColumnName(sb, fieldType, fieldTypeList);
            if (fieldType != this.idField) continue;
            hasId = true;
        }
        if (!hasId && this.selectIdColumn) {
            if (!first) {
                sb.append(',');
            }
            this.appendFieldColumnName(sb, this.idField, fieldTypeList);
        }
        sb.append(' ');
    }

    private void appendFieldColumnName(StringBuilder sb, FieldType fieldType, List<FieldType> fieldTypeList) {
        this.databaseType.appendEscapedEntityName(sb, fieldType.getDbColumnName());
        if (fieldTypeList != null) {
            fieldTypeList.add(fieldType);
        }
    }

    private void appendLimit(StringBuilder sb) {
        if (this.limit != null && this.databaseType.isLimitSqlSupported()) {
            this.databaseType.appendLimitValue(sb, this.limit);
        }
    }

    private void appendGroupBys(StringBuilder sb) {
        if (this.groupByList == null || this.groupByList.size() == 0) {
            return;
        }
        sb.append("GROUP BY ");
        boolean first = true;
        for (String columnName : this.groupByList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            this.databaseType.appendEscapedEntityName(sb, columnName);
        }
        sb.append(' ');
    }

    private void appendOrderBys(StringBuilder sb) {
        if (this.orderByList == null || this.orderByList.size() == 0) {
            return;
        }
        sb.append("ORDER BY ");
        boolean first = true;
        for (OrderBy orderBy : this.orderByList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            String columnName = orderBy.getColumnName();
            this.verifyColumnName(columnName);
            this.databaseType.appendEscapedEntityName(sb, columnName);
            if (orderBy.isAscending()) continue;
            sb.append(" DESC");
        }
        sb.append(' ');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InternalQueryBuilder<T, ID>
    extends QueryBuilder<T, ID> {
        public InternalQueryBuilder(DatabaseType databaseType, TableInfo<T> tableInfo) {
            super(databaseType, tableInfo);
        }

        @Override
        public String buildStatementString(List<FieldType> argFieldTypeList, List<FieldType> resultFieldTypeList, List<SelectArg> selectArgList) throws SQLException {
            return super.buildStatementString(argFieldTypeList, resultFieldTypeList, selectArgList);
        }
    }
}

