/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseType
extends BaseDatabaseType
implements DatabaseType {
    private static final String DATABASE_URL_PORTION = "oracle";
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    private static final String DATABASE_NAME = "Oracle";

    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    protected void appendStringType(StringBuilder sb, int fieldWidth) {
        sb.append("VARCHAR2(").append(fieldWidth).append(")");
    }

    protected void appendLongStringType(StringBuilder sb, int fieldWidth) {
        sb.append("LONG");
    }

    protected void appendByteType(StringBuilder sb, int fieldWidth) {
        sb.append("SMALLINT");
    }

    protected void appendLongType(StringBuilder sb, int fieldWidth) {
        sb.append("NUMERIC");
    }

    protected void appendByteArrayType(StringBuilder sb, int fieldWidth) {
        sb.append("LONG RAW");
    }

    protected void appendSerializableType(StringBuilder sb, int fieldWidth) {
        sb.append("LONG RAW");
    }

    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        String seqName = fieldType.getGeneratedIdSequence();
        StringBuilder seqSb = new StringBuilder(64);
        seqSb.append("CREATE SEQUENCE ");
        this.appendEscapedEntityName(seqSb, seqName);
        statementsBefore.add(seqSb.toString());
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    protected void configureId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("PRIMARY KEY ");
    }

    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
        if (fieldType.isGeneratedIdSequence()) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("DROP SEQUENCE ");
            this.appendEscapedEntityName(sb, fieldType.getGeneratedIdSequence());
            statementsAfter.add(sb.toString());
        }
    }

    public void appendEscapedEntityName(StringBuilder sb, String word) {
        sb.append('\"').append(word).append('\"');
    }

    public boolean isIdSequenceNeeded() {
        return true;
    }

    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
        sb.append("SELECT ");
        this.appendEscapedEntityName(sb, sequenceName);
        sb.append(".nextval FROM dual");
    }

    public String getPingStatement() {
        return "SELECT 1 FROM DUAL";
    }

    public boolean isOffsetSqlSupported() {
        return false;
    }
}

