/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.mapped.BaseMappedStatement;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMappedQuery<T>
extends BaseMappedStatement<T>
implements GenericRowMapper<T> {
    protected final FieldType[] resultsFieldTypes;
    private Map<String, Integer> columnPositions = null;

    protected BaseMappedQuery(TableInfo<T> tableInfo, String statement, List<FieldType> argFieldTypeList, List<FieldType> resultFieldTypeList) {
        super(tableInfo, statement, argFieldTypeList);
        this.resultsFieldTypes = resultFieldTypeList.toArray(new FieldType[resultFieldTypeList.size()]);
    }

    @Override
    public T mapRow(DatabaseResults results) throws SQLException {
        if (this.columnPositions == null) {
            this.columnPositions = new HashMap<String, Integer>();
        }
        Object instance = this.tableInfo.createObject();
        for (FieldType fieldType : this.resultsFieldTypes) {
            Object val = fieldType.resultToJava(results, this.columnPositions);
            fieldType.assignField(instance, val);
        }
        return instance;
    }
}

