/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.DatabaseTypeUtils;
import com.j256.ormlite.jdbc.JdbcDatabaseConnection;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceConnectionSource
implements ConnectionSource {
    private DataSource dataSource;
    private DatabaseType databaseType;
    private String databaseUrl;
    private boolean initialized = false;

    public DataSourceConnectionSource() {
    }

    public DataSourceConnectionSource(DataSource dataSource, String databaseUrl) throws SQLException {
        this.dataSource = dataSource;
        this.databaseUrl = databaseUrl;
        this.initialize();
    }

    public DataSourceConnectionSource(DataSource dataSource, DatabaseType databaseType) throws SQLException {
        this.dataSource = dataSource;
        this.databaseType = databaseType;
        this.initialize();
    }

    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        if (this.dataSource == null) {
            throw new IllegalStateException("dataSource was never set on " + this.getClass().getSimpleName());
        }
        if (this.databaseType == null) {
            if (this.databaseUrl == null) {
                throw new IllegalStateException("either the databaseUri or the databaseType must be set on " + this.getClass().getSimpleName());
            }
            this.databaseType = DatabaseTypeUtils.createDatabaseType(this.databaseUrl);
        }
        this.databaseType.loadDriver();
        this.initialized = true;
    }

    public DatabaseConnection getReadOnlyConnection() throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
        return this.getReadWriteConnection();
    }

    public DatabaseConnection getReadOnlyConnection(String username, String password) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
        return this.getReadWriteConnection(username, password);
    }

    public DatabaseConnection getReadWriteConnection() throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
        return new JdbcDatabaseConnection(this.dataSource.getConnection());
    }

    public void releaseConnection(DatabaseConnection connection) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
    }

    public DatabaseConnection getReadWriteConnection(String username, String password) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
        return new JdbcDatabaseConnection(this.dataSource.getConnection(username, password));
    }

    public void close() throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
    }

    public DatabaseType getDatabaseType() {
        if (!this.initialized) {
            throw new IllegalStateException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
        return this.databaseType;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }
}

