/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.mapped.BaseMappedQuery;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedQueryForId<T, ID>
extends BaseMappedQuery<T> {
    private final String label;

    protected MappedQueryForId(TableInfo<T> tableInfo, String statement, List<FieldType> argFieldTypeList, List<FieldType> resultFieldTypeList, String label) {
        super(tableInfo, statement, argFieldTypeList, resultFieldTypeList);
        this.label = label;
    }

    public T execute(DatabaseConnection databaseConnection, Object obj) throws SQLException {
        Object[] args = new Object[]{this.getId(obj)};
        Object result = databaseConnection.queryForOne(this.statement, args, new SqlType[]{this.idField.getSqlTypeVal()}, this);
        if (result == DatabaseConnection.MORE_THAN_ONE) {
            logger.error("{} using '{}' and {} args, got >1 results", this.label, this.statement, args.length);
            this.logArgs(args);
            throw new SQLException(this.label + " got more than 1 result: " + this.statement);
        }
        logger.debug("{} using '{}' and {} args, got 1 result", this.label, this.statement, args.length);
        this.logArgs(args);
        Object castResult = result;
        this.postProcessResult(obj, castResult);
        return (T)castResult;
    }

    protected ID getId(Object obj) throws SQLException {
        Object id = obj;
        return (ID)id;
    }

    protected void postProcessResult(Object obj, T result) throws SQLException {
    }

    public static <T, ID> MappedQueryForId<T, ID> build(DatabaseType databaseType, TableInfo<T> tableInfo) throws SQLException {
        ArrayList<FieldType> argFieldTypeList = new ArrayList<FieldType>();
        ArrayList<FieldType> resultFieldTypeList = new ArrayList<FieldType>();
        String statement = MappedQueryForId.buildStatement(databaseType, tableInfo, argFieldTypeList, resultFieldTypeList);
        return new MappedQueryForId<T, ID>(tableInfo, statement, argFieldTypeList, resultFieldTypeList, "query-for-id");
    }

    protected static <ID, T> String buildStatement(DatabaseType databaseType, TableInfo<T> tableInfo, List<FieldType> argFieldTypeList, List<FieldType> resultFieldTypeList) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot query-for-id with " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        StatementBuilder.InternalQueryBuilder qb = new StatementBuilder.InternalQueryBuilder(databaseType, tableInfo);
        SelectArg idSelectArg = new SelectArg();
        qb.where().eq(idField.getDbColumnName(), idSelectArg);
        ArrayList<SelectArg> selectArgList = new ArrayList<SelectArg>();
        return qb.buildSelectString(argFieldTypeList, resultFieldTypeList, selectArgList);
    }

    private void logArgs(Object[] args) {
        if (args.length > 0) {
            logger.trace("{} arguments: {}", this.label, args);
        }
    }
}

