/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.field.FieldType;
import java.sql.SQLException;

public class SelectArg {
    private boolean hasBeenSet = false;
    private String columnName = null;
    private FieldType fieldType = null;
    private Object value = null;

    public String getColumnName() {
        if (this.columnName == null) {
            throw new IllegalArgumentException("Column name has not been set");
        }
        return this.columnName;
    }

    public void setMetaInfo(String columnName, FieldType fieldType) {
        if (this.columnName != null && !this.columnName.equals(columnName)) {
            throw new IllegalArgumentException("Column name cannot be set twice from " + this.columnName + " to " + columnName);
        }
        if (this.fieldType != null && this.fieldType != fieldType) {
            throw new IllegalArgumentException("FieldType name cannot be set twice from " + this.fieldType + " to " + fieldType);
        }
        this.columnName = columnName;
        this.fieldType = fieldType;
    }

    public Object getValue() throws SQLException {
        if (!this.hasBeenSet) {
            throw new SQLException("Column value has not been set for " + this.columnName);
        }
        if (this.fieldType != null && this.fieldType.isForeign() && this.fieldType.getFieldType() == this.value.getClass()) {
            FieldType idFieldType = this.fieldType.getForeignIdField();
            return idFieldType.getFieldValue(this.value);
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.hasBeenSet = true;
        this.value = value;
    }

    public String toString() {
        if (this.hasBeenSet) {
            return "set arg(" + this.getValueString() + ")";
        }
        return "unset arg()";
    }

    private String getValueString() {
        if (this.value == null) {
            return "[null]";
        }
        try {
            Object val = this.getValue();
            if (val == null) {
                return "[null]";
            }
            return val.toString();
        }
        catch (SQLException e) {
            return "[could not get value: " + e.getMessage() + "]";
        }
    }
}

