/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.query;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.query.Comparison;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseComparison
implements Comparison {
    protected final String columnName;
    protected final boolean isNumber;
    private final Object value;

    protected BaseComparison(String columnName, boolean isNumber, Object value) {
        this.columnName = columnName;
        this.isNumber = isNumber;
        this.value = value;
    }

    @Override
    public abstract StringBuilder appendOperation(StringBuilder var1);

    @Override
    public StringBuilder appendSql(DatabaseType databaseType, StringBuilder sb, List<SelectArg> selectArgList) {
        databaseType.appendEscapedEntityName(sb, this.columnName);
        sb.append(' ');
        this.appendOperation(sb);
        this.appendValue(databaseType, sb, selectArgList);
        return sb;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public StringBuilder appendValue(DatabaseType databaseType, StringBuilder sb, List<SelectArg> selectArgList) {
        this.appendArgOrValue(databaseType, sb, selectArgList, this.value);
        return sb;
    }

    protected void appendArgOrValue(DatabaseType databaseType, StringBuilder sb, List<SelectArg> selectArgList, Object argOrValue) {
        if (argOrValue == null) {
            throw new IllegalArgumentException("argument to comparison of '" + this.columnName + "' is null");
        }
        if (argOrValue instanceof SelectArg) {
            sb.append('?');
            SelectArg selectArg = (SelectArg)argOrValue;
            selectArg.setColumnName(this.columnName);
            selectArgList.add(selectArg);
        } else if (this.isNumber) {
            sb.append(argOrValue.toString());
        } else {
            databaseType.appendEscapedWord(sb, argOrValue.toString());
        }
        sb.append(' ');
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.columnName).append(' ');
        this.appendOperation(sb).append(' ');
        sb.append(this.value);
        return sb.toString();
    }
}

