/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.FieldConverter;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseResults;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyEmbeddedDatabaseType
extends BaseDatabaseType
implements DatabaseType {
    private static final String DATABASE_URL_PORTION = "derby";
    private static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final FieldConverter objectConverter = new ObjectFieldConverter();

    @Override
    public String getDriverUrlPart() {
        return DATABASE_URL_PORTION;
    }

    @Override
    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public FieldConverter getFieldConverter(DataType dataType) {
        switch (dataType) {
            case BOOLEAN: 
            case BOOLEAN_OBJ: {
                return booleanConverter;
            }
            case SERIALIZABLE: {
                return objectConverter;
            }
        }
        return super.getFieldConverter(dataType);
    }

    @Override
    protected void appendBooleanType(StringBuilder sb) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendByteType(StringBuilder sb) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendObjectType(StringBuilder sb) {
        sb.append("BLOB");
    }

    @Override
    protected void configureGeneratedId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("GENERATED BY DEFAULT AS IDENTITY ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String word) {
        sb.append('\"').append(word).append('\"');
    }

    @Override
    public boolean isLimitSqlSupported() {
        return false;
    }

    @Override
    public boolean isEntityNamesMustBeUpCase() {
        return true;
    }

    private static class ObjectFieldConverter
    implements FieldConverter {
        private ObjectFieldConverter() {
        }

        public SqlType getSqlType() {
            return SqlType.BLOB;
        }

        public Object javaToArg(FieldType fieldType, Object javaObject) throws SQLException {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objOutStream = new ObjectOutputStream(outStream);
                objOutStream.writeObject(javaObject);
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not write serialized object to output stream", e);
            }
            return new SerialBlob(outStream.toByteArray());
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            throw new SQLException("Default values for serializable types are not supported");
        }

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            InputStream stream = results.getBlobStream(columnPos);
            if (stream == null) {
                return null;
            }
            try {
                ObjectInputStream objInStream = new ObjectInputStream(stream);
                return objInStream.readObject();
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not read serialized object from result blob", e);
            }
        }

        public boolean isStreamType() {
            return true;
        }
    }
}

