/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.android.DatabaseTableConfigUtil;
import com.j256.ormlite.db.BaseSqliteDatabaseType;
import com.j256.ormlite.field.DataPersister;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.types.DateStringType;
import com.j256.ormlite.field.types.SqlDateStringType;
import com.j256.ormlite.field.types.SqlDateType;
import com.j256.ormlite.field.types.TimeStampStringType;
import com.j256.ormlite.field.types.TimeStampType;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.sql.SQLException;

public class SqliteAndroidDatabaseType
extends BaseSqliteDatabaseType {
    @Override
    public boolean loadDriver() {
        return true;
    }

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return true;
    }

    @Override
    public String getDatabaseName() {
        return "Android SQLite";
    }

    @Override
    protected void appendDateType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        this.appendStringType(sb, fieldType, fieldWidth);
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('`').append(name).append('`');
    }

    @Override
    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        this.appendShortType(sb, fieldType, fieldWidth);
    }

    @Override
    public DataPersister getDataPersister(DataPersister defaultPersister, FieldType fieldType) {
        if (defaultPersister == null) {
            return super.getDataPersister(defaultPersister, fieldType);
        }
        switch (defaultPersister.getSqlType()) {
            case DATE: {
                if (defaultPersister instanceof TimeStampType) {
                    return TimeStampStringType.getSingleton();
                }
                if (defaultPersister instanceof SqlDateType) {
                    return SqlDateStringType.getSingleton();
                }
                return DateStringType.getSingleton();
            }
        }
        return super.getDataPersister(defaultPersister, fieldType);
    }

    @Override
    public boolean isNestedSavePointsSupported() {
        return false;
    }

    @Override
    public boolean isBatchUseTransaction() {
        return true;
    }

    @Override
    public <T> DatabaseTableConfig<T> extractDatabaseTableConfig(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        return DatabaseTableConfigUtil.fromClass(connectionSource, clazz);
    }
}

