/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.Cursor;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.SqliteAndroidDatabaseType;
import com.j256.ormlite.support.DatabaseResults;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AndroidDatabaseResults
implements DatabaseResults {
    private static final int MIN_NUM_COLUMN_NAMES_MAP = 8;
    private final Cursor cursor;
    private final String[] columnNames;
    private final Map<String, Integer> columnNameMap;
    private final ObjectCache objectCache;
    private final boolean cacheStore;
    private static final DatabaseType databaseType = new SqliteAndroidDatabaseType();

    public AndroidDatabaseResults(Cursor cursor, ObjectCache objectCache, boolean cacheStore) {
        this.cursor = cursor;
        this.columnNames = cursor.getColumnNames();
        if (this.columnNames.length >= 8) {
            this.columnNameMap = new HashMap<String, Integer>();
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columnNameMap.put(this.columnNames[i], i);
            }
        } else {
            this.columnNameMap = null;
        }
        this.objectCache = objectCache;
        this.cacheStore = cacheStore;
    }

    @Override
    public int getColumnCount() {
        return this.cursor.getColumnCount();
    }

    @Override
    public String[] getColumnNames() {
        int colN = this.getColumnCount();
        String[] columnNames = new String[colN];
        for (int colC = 0; colC < colN; ++colC) {
            columnNames[colC] = this.cursor.getColumnName(colC);
        }
        return columnNames;
    }

    @Override
    public boolean first() {
        return this.cursor.moveToFirst();
    }

    @Override
    public boolean next() {
        return this.cursor.moveToNext();
    }

    @Override
    public boolean last() {
        return this.cursor.moveToLast();
    }

    @Override
    public boolean previous() {
        return this.cursor.moveToPrevious();
    }

    @Override
    public boolean moveRelative(int offset) {
        return this.cursor.move(offset);
    }

    @Override
    public boolean moveAbsolute(int position) {
        return this.cursor.moveToPosition(position);
    }

    public int getCount() {
        return this.cursor.getCount();
    }

    public int getPosition() {
        return this.cursor.getPosition();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        int index = this.lookupColumn(columnName);
        if (index >= 0) {
            return index;
        }
        StringBuilder sb = new StringBuilder(columnName.length() + 4);
        databaseType.appendEscapedEntityName(sb, columnName);
        index = this.lookupColumn(sb.toString());
        if (index >= 0) {
            return index;
        }
        Object[] columnNames = this.cursor.getColumnNames();
        throw new SQLException("Unknown field '" + columnName + "' from the Android sqlite cursor, not in:" + Arrays.toString(columnNames));
    }

    @Override
    public String getString(int columnIndex) {
        return this.cursor.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        return !this.cursor.isNull(columnIndex) && this.cursor.getShort(columnIndex) != 0;
    }

    @Override
    public char getChar(int columnIndex) throws SQLException {
        String string = this.cursor.getString(columnIndex);
        if (string == null || string.length() == 0) {
            return '\u0000';
        }
        if (string.length() == 1) {
            return string.charAt(0);
        }
        throw new SQLException("More than 1 character stored in database column: " + columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) {
        return (byte)this.getShort(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) {
        return this.cursor.getBlob(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) {
        return this.cursor.getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) {
        return this.cursor.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) {
        return this.cursor.getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) {
        return this.cursor.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) {
        return this.cursor.getDouble(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw new SQLException("Android does not support timestamp.  Use JAVA_DATE_LONG or JAVA_DATE_STRING types");
    }

    @Override
    public InputStream getBlobStream(int columnIndex) {
        return new ByteArrayInputStream(this.cursor.getBlob(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new SQLException("Android does not support BigDecimal type.  Use BIG_DECIMAL or BIG_DECIMAL_STRING types");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        throw new SQLException("Android does not support Object type.");
    }

    @Override
    public boolean wasNull(int columnIndex) {
        return this.cursor.isNull(columnIndex);
    }

    @Override
    public ObjectCache getObjectCacheForRetrieve() {
        return this.objectCache;
    }

    @Override
    public ObjectCache getObjectCacheForStore() {
        if (this.cacheStore) {
            return this.objectCache;
        }
        return null;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public void closeQuietly() {
        this.close();
    }

    public Cursor getRawCursor() {
        return this.cursor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
    }

    private int lookupColumn(String columnName) {
        if (this.columnNameMap == null) {
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (!this.columnNames[i].equals(columnName)) continue;
                return i;
            }
            return -1;
        }
        Integer index = this.columnNameMap.get(columnName);
        if (index == null) {
            return -1;
        }
        return index;
    }
}

