/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.Log;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log4jLog
implements Log {
    private Object logger;
    private static Method getLoggerMethod;
    private static Method isEnabledForMethod;
    private static Object traceLevel;
    private static Object debugLevel;
    private static Object infoLevel;
    private static Object warnLevel;
    private static Object errorLevel;
    private static Object fatalLevel;
    private static Method traceMethod;
    private static Method traceThrowableMethod;
    private static Method debugMethod;
    private static Method debugThrowableMethod;
    private static Method infoMethod;
    private static Method infoThrowableMethod;
    private static Method warnMethod;
    private static Method warnThrowableMethod;
    private static Method errorMethod;
    private static Method errorThrowableMethod;
    private static Method fatalMethod;
    private static Method fatalThrowableMethod;

    public Log4jLog(String className) {
        if (getLoggerMethod == null) {
            Log4jLog.findMethods();
        }
        if (getLoggerMethod != null) {
            try {
                this.logger = getLoggerMethod.invoke(null, className);
            }
            catch (Exception e) {
                this.logger = null;
            }
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabledFor(traceLevel);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabledFor(debugLevel);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabledFor(infoLevel);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabledFor(warnLevel);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabledFor(errorLevel);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabledFor(fatalLevel);
    }

    @Override
    public void trace(String msg) {
        this.logMessage(traceMethod, msg);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logMessage(traceThrowableMethod, msg, t);
    }

    @Override
    public void debug(String msg) {
        this.logMessage(debugMethod, msg);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logMessage(debugThrowableMethod, msg, t);
    }

    @Override
    public void info(String msg) {
        this.logMessage(infoMethod, msg);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logMessage(infoThrowableMethod, msg, t);
    }

    @Override
    public void warn(String msg) {
        this.logMessage(warnMethod, msg);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logMessage(warnThrowableMethod, msg, t);
    }

    @Override
    public void error(String msg) {
        this.logMessage(errorMethod, msg);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logMessage(errorThrowableMethod, msg, t);
    }

    @Override
    public void fatal(String msg) {
        this.logMessage(fatalMethod, msg);
    }

    @Override
    public void fatal(String msg, Throwable t) {
        this.logMessage(fatalThrowableMethod, msg, t);
    }

    private static void findMethods() {
        Class<?> levelClazz;
        Class<?> priorityClazz;
        Class<?> clazz;
        try {
            clazz = Class.forName("org.apache.log4j.Logger");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        getLoggerMethod = Log4jLog.getMethod(clazz, "getLogger", String.class);
        try {
            priorityClazz = Class.forName("org.apache.log4j.Priority");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        isEnabledForMethod = Log4jLog.getMethod(clazz, "isEnabledFor", priorityClazz);
        try {
            levelClazz = Class.forName("org.apache.log4j.Level");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        traceLevel = Log4jLog.getLevelField(levelClazz, "TRACE");
        debugLevel = Log4jLog.getLevelField(levelClazz, "DEBUG");
        infoLevel = Log4jLog.getLevelField(levelClazz, "INFO");
        warnLevel = Log4jLog.getLevelField(levelClazz, "WARN");
        errorLevel = Log4jLog.getLevelField(levelClazz, "ERROR");
        fatalLevel = Log4jLog.getLevelField(levelClazz, "FATAL");
        traceMethod = Log4jLog.getMethod(clazz, "trace", Object.class);
        traceThrowableMethod = Log4jLog.getMethod(clazz, "trace", Object.class, Throwable.class);
        debugMethod = Log4jLog.getMethod(clazz, "debug", Object.class);
        debugThrowableMethod = Log4jLog.getMethod(clazz, "debug", Object.class, Throwable.class);
        infoMethod = Log4jLog.getMethod(clazz, "info", Object.class);
        infoThrowableMethod = Log4jLog.getMethod(clazz, "info", Object.class, Throwable.class);
        warnMethod = Log4jLog.getMethod(clazz, "warn", Object.class);
        warnThrowableMethod = Log4jLog.getMethod(clazz, "warn", Object.class, Throwable.class);
        errorMethod = Log4jLog.getMethod(clazz, "error", Object.class);
        errorThrowableMethod = Log4jLog.getMethod(clazz, "error", Object.class, Throwable.class);
        fatalMethod = Log4jLog.getMethod(clazz, "fatal", Object.class);
        fatalThrowableMethod = Log4jLog.getMethod(clazz, "fatal", Object.class, Throwable.class);
    }

    private boolean isEnabledFor(Object level) {
        if (this.logger != null) {
            try {
                return (Boolean)isEnabledForMethod.invoke(this.logger, level);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void logMessage(Method method, String message) {
        if (this.logger != null) {
            try {
                method.invoke(this.logger, message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void logMessage(Method method, String message, Throwable t) {
        if (this.logger != null) {
            try {
                method.invoke(this.logger, message, t);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getLevelField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getField(fieldName).get(null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

