/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field;

import com.j256.ormlite.field.FieldConverter;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseResults;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataType implements FieldConverter
{
    STRING(SqlType.STRING, null, new Class[]{String.class}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getString(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return defaultStr;
        }
    }
    ,
    BOOLEAN(SqlType.BOOLEAN, null, new Class[]{Boolean.TYPE}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getBoolean(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Boolean.parseBoolean(defaultStr);
        }

        public boolean isEscapeDefaultValue() {
            return false;
        }

        public boolean isPrimitive() {
            return true;
        }
    }
    ,
    BOOLEAN_OBJ(SqlType.BOOLEAN, null, new Class[]{Boolean.class}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getBoolean(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Boolean.parseBoolean(defaultStr);
        }

        public boolean isEscapeDefaultValue() {
            return false;
        }
    }
    ,
    JAVA_DATE(SqlType.DATE, null, new Class[]{Date.class}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return new Date(results.getTimestamp(columnPos).getTime());
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            try {
                return new Timestamp(DataType.parseDateString(fieldType.getFormat(), defaultStr).getTime());
            }
            catch (ParseException e) {
                throw SqlExceptionUtil.create("Problems parsing default date string '" + defaultStr + "' using '" + DataType.formatOrDefault(fieldType.getFormat()) + '\'', e);
            }
        }

        public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
            Date date = (Date)javaObject;
            return new Timestamp(date.getTime());
        }
    }
    ,
    JAVA_DATE_LONG(SqlType.LONG, null, new Class[0]){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return new Date(results.getLong(columnPos));
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            try {
                return Long.parseLong(defaultStr);
            }
            catch (NumberFormatException e) {
                throw SqlExceptionUtil.create("Problems with field " + fieldType + " parsing default date-long value: " + defaultStr, e);
            }
        }

        public Object javaToSqlArg(FieldType fieldType, Object obj) {
            Date date = (Date)obj;
            return date.getTime();
        }

        public boolean isNumber() {
            return true;
        }
    }
    ,
    JAVA_DATE_STRING(SqlType.STRING, null, new Class[0]){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            String formatStr = fieldType.getFormat();
            String dateStr = results.getString(columnPos);
            try {
                return DataType.parseDateString(formatStr, dateStr);
            }
            catch (ParseException e) {
                throw SqlExceptionUtil.create("Problems with field " + fieldType + " parsing date-string '" + dateStr + "' using '" + DataType.formatOrDefault(formatStr) + "'", e);
            }
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            try {
                return DataType.normalizeDateString(fieldType.getFormat(), defaultStr);
            }
            catch (ParseException e) {
                throw SqlExceptionUtil.create("Problems with field " + fieldType + " parsing default date-string '" + defaultStr + "' using '" + DataType.formatOrDefault(fieldType.getFormat()) + "'", e);
            }
        }

        public Object javaToSqlArg(FieldType fieldType, Object obj) {
            Date date = (Date)obj;
            return DataType.formatDate(fieldType.getFormat(), date);
        }
    }
    ,
    BYTE(SqlType.BYTE, null, new Class[]{Byte.TYPE}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getByte(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Byte.parseByte(defaultStr);
        }

        public boolean isNumber() {
            return true;
        }

        public boolean isPrimitive() {
            return true;
        }
    }
    ,
    BYTE_OBJ(SqlType.BYTE, null, new Class[]{Byte.class}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getByte(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Byte.parseByte(defaultStr);
        }

        public boolean isNumber() {
            return true;
        }
    }
    ,
    SHORT(SqlType.SHORT, null, new Class[]{Short.TYPE}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getShort(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Short.parseShort(defaultStr);
        }

        public boolean isNumber() {
            return true;
        }

        public boolean isPrimitive() {
            return true;
        }
    }
    ,
    SHORT_OBJ(SqlType.SHORT, null, new Class[]{Short.class}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getShort(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Short.parseShort(defaultStr);
        }

        public boolean isNumber() {
            return true;
        }
    }
    ,
    INTEGER(SqlType.INTEGER, SqlType.INTEGER, new Class[]{Integer.TYPE}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getInt(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Integer.parseInt(defaultStr);
        }

        public Object convertIdNumber(Number number) {
            return number.intValue();
        }

        public Number resultToId(DatabaseResults results, int columnPos) throws SQLException {
            return results.getInt(columnPos);
        }

        public boolean isNumber() {
            return true;
        }

        public boolean isPrimitive() {
            return true;
        }
    }
    ,
    INTEGER_OBJ(SqlType.INTEGER, null, new Class[]{Integer.class}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getInt(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Integer.parseInt(defaultStr);
        }

        public Object convertIdNumber(Number number) {
            return number.intValue();
        }

        public Number resultToId(DatabaseResults results, int columnPos) throws SQLException {
            return results.getInt(columnPos);
        }

        public boolean isNumber() {
            return true;
        }
    }
    ,
    LONG(SqlType.LONG, SqlType.LONG, new Class[]{Long.TYPE}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getLong(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Long.parseLong(defaultStr);
        }

        public Object convertIdNumber(Number number) {
            return number.longValue();
        }

        public Number resultToId(DatabaseResults results, int columnPos) throws SQLException {
            return results.getLong(columnPos);
        }

        public boolean isNumber() {
            return true;
        }

        public boolean isPrimitive() {
            return true;
        }
    }
    ,
    LONG_OBJ(SqlType.LONG, null, new Class[]{Long.class}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getLong(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Long.parseLong(defaultStr);
        }

        public Object convertIdNumber(Number number) {
            return number.longValue();
        }

        public Number resultToId(DatabaseResults results, int columnPos) throws SQLException {
            return results.getLong(columnPos);
        }

        public boolean isNumber() {
            return true;
        }
    }
    ,
    FLOAT(SqlType.FLOAT, null, new Class[]{Float.TYPE}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return Float.valueOf(results.getFloat(columnPos));
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Float.valueOf(Float.parseFloat(defaultStr));
        }

        public boolean isNumber() {
            return true;
        }

        public boolean isPrimitive() {
            return true;
        }
    }
    ,
    FLOAT_OBJ(SqlType.FLOAT, null, new Class[]{Float.class}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return Float.valueOf(results.getFloat(columnPos));
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Float.valueOf(Float.parseFloat(defaultStr));
        }

        public boolean isNumber() {
            return true;
        }
    }
    ,
    DOUBLE(SqlType.DOUBLE, null, new Class[]{Double.TYPE}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getDouble(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Double.parseDouble(defaultStr);
        }

        public boolean isNumber() {
            return true;
        }

        public boolean isPrimitive() {
            return true;
        }
    }
    ,
    DOUBLE_OBJ(SqlType.DOUBLE, null, new Class[]{Double.class}){

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getDouble(columnPos);
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Double.parseDouble(defaultStr);
        }

        public boolean isNumber() {
            return true;
        }
    }
    ,
    SERIALIZABLE(SqlType.SERIALIZABLE, null, new Class[]{Object.class}){

        @Override
        public Object javaToSqlArg(FieldType fieldType, Object obj) throws SQLException {
            try {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                ObjectOutputStream objOutStream = new ObjectOutputStream(outStream);
                objOutStream.writeObject(obj);
                return outStream.toByteArray();
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not write serialized object to byte array: " + obj, e);
            }
        }

        @Override
        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            throw new SQLException("Default values for serializable types are not supported");
        }

        @Override
        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            byte[] bytes = results.getBytes(columnPos);
            if (bytes == null) {
                return null;
            }
            try {
                ObjectInputStream objInStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
                return objInStream.readObject();
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not read serialized object from byte array: " + Arrays.toString(bytes) + "(len " + bytes.length + ")", e);
            }
        }

        @Override
        public boolean isValidForType(Class<?> fieldClass) {
            return Serializable.class.isAssignableFrom(fieldClass);
        }

        @Override
        public boolean isStreamType() {
            return true;
        }
    }
    ,
    ENUM_STRING(SqlType.STRING, null, new Class[]{Enum.class}){

        public Object javaToSqlArg(FieldType fieldType, Object obj) throws SQLException {
            Enum enumVal = (Enum)obj;
            return enumVal.name();
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return defaultStr;
        }

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            String val = results.getString(columnPos);
            return fieldType.enumFromString(val);
        }
    }
    ,
    ENUM_INTEGER(SqlType.INTEGER, null, new Class[]{Enum.class}){

        public Object javaToSqlArg(FieldType fieldType, Object obj) throws SQLException {
            Enum enumVal = (Enum)obj;
            return enumVal.ordinal();
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Integer.parseInt(defaultStr);
        }

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return fieldType.enumFromInt(results.getInt(columnPos));
        }

        public boolean isNumber() {
            return true;
        }
    }
    ,
    UNKNOWN(SqlType.UNKNOWN, null, new Class[0]){

        public Object javaToSqlArg(FieldType fieldType, Object obj) throws SQLException {
            return null;
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return null;
        }

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return null;
        }
    };

    public static final String DEFAULT_DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    private static Map<String, DateFormat> dateFormatMap;
    private final SqlType sqlType;
    private final SqlType convertForSqlType;
    private final boolean canBeGenerated;
    private final Class<?>[] classes;

    private DataType(SqlType sqlType, SqlType convertForSqlType, Class<?>[] classes) {
        this.sqlType = sqlType;
        this.convertForSqlType = convertForSqlType;
        this.canBeGenerated = this.convertIdNumber(10) != null;
        this.classes = classes;
    }

    @Override
    public abstract Object resultToJava(FieldType var1, DatabaseResults var2, int var3) throws SQLException;

    @Override
    public abstract Object parseDefaultString(FieldType var1, String var2) throws SQLException;

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object javaObject) throws SQLException {
        return javaObject;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    public boolean isValidGeneratedType() {
        return this.canBeGenerated;
    }

    public Object convertIdNumber(Number number) {
        return null;
    }

    public Number resultToId(DatabaseResults results, int columnPos) throws SQLException {
        return null;
    }

    public boolean isValidForType(Class<?> fieldClass) {
        return true;
    }

    public static DataType lookupClass(Class<?> dataClass) {
        for (DataType dataType : DataType.values()) {
            for (Class<?> dataTypeClass : dataType.classes) {
                if (dataTypeClass != dataClass) continue;
                return dataType;
            }
        }
        if (dataClass.isEnum()) {
            return ENUM_STRING;
        }
        if (Serializable.class.isAssignableFrom(dataClass)) {
            return SERIALIZABLE;
        }
        return UNKNOWN;
    }

    public static DataType dataTypeFromSqlType(SqlType sqlType) {
        for (DataType dataType : DataType.values()) {
            if (dataType.convertForSqlType != sqlType) continue;
            return dataType;
        }
        return null;
    }

    public boolean isEscapeDefaultValue() {
        return !this.isNumber();
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isStreamType() {
        return false;
    }

    private static synchronized Date parseDateString(String format, String dateStr) throws ParseException {
        DateFormat dateFormat = DataType.getDateFormat(format);
        return dateFormat.parse(dateStr);
    }

    private static synchronized String normalizeDateString(String format, String dateStr) throws ParseException {
        DateFormat dateFormat = DataType.getDateFormat(format);
        Date date = dateFormat.parse(dateStr);
        return dateFormat.format(date);
    }

    private static synchronized String formatDate(String format, Date date) {
        DateFormat dateFormat = DataType.getDateFormat(format);
        return dateFormat.format(date);
    }

    private static DateFormat getDateFormat(String formatStr) {
        DateFormat dateFormat;
        if (dateFormatMap == null) {
            dateFormatMap = new HashMap<String, DateFormat>();
        }
        if ((dateFormat = dateFormatMap.get(formatStr = DataType.formatOrDefault(formatStr))) == null) {
            dateFormat = new SimpleDateFormat(formatStr);
            dateFormatMap.put(formatStr, dateFormat);
        }
        return dateFormat;
    }

    private static String formatOrDefault(String format) {
        if (format == null) {
            return DEFAULT_DATE_FORMAT_STRING;
        }
        return format;
    }
}

