/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android.apptools;

import android.content.Context;
import android.content.res.Resources;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenHelperManager {
    private static final String HELPER_CLASS_RESOURCE_NAME = "open_helper_classname";
    private static Logger logger = LoggerFactory.getLogger(OpenHelperManager.class);
    private static Class<? extends OrmLiteSqliteOpenHelper> helperClass = null;
    private static volatile OrmLiteSqliteOpenHelper helper = null;
    private static boolean wasClosed = false;
    private static int instanceCount = 0;

    public static synchronized void setOpenHelperClass(Class<? extends OrmLiteSqliteOpenHelper> openHelperClass) {
        if (openHelperClass == null) {
            helperClass = null;
        } else {
            OpenHelperManager.innerSetHelperClass(openHelperClass);
        }
    }

    public static synchronized void setHelper(OrmLiteSqliteOpenHelper helper) {
        OpenHelperManager.helper = helper;
    }

    public static synchronized <T extends OrmLiteSqliteOpenHelper> T getHelper(Context context, Class<T> openHelperClass) {
        OpenHelperManager.innerSetHelperClass(openHelperClass);
        return OpenHelperManager.loadHelper(context, openHelperClass);
    }

    @Deprecated
    public static synchronized OrmLiteSqliteOpenHelper getHelper(Context context) {
        if (helperClass == null) {
            if (context == null) {
                throw new IllegalArgumentException("context argument is null");
            }
            Context appContext = context.getApplicationContext();
            OpenHelperManager.innerSetHelperClass(OpenHelperManager.lookupHelperClass(appContext, context.getClass()));
        }
        return OpenHelperManager.loadHelper(context, helperClass);
    }

    @Deprecated
    public static void release() {
        OpenHelperManager.releaseHelper();
    }

    public static synchronized void releaseHelper() {
        logger.trace("releasing helper {}, instance count = {}", (Object)helper, (Object)(--instanceCount));
        if (instanceCount <= 0) {
            if (helper != null) {
                logger.trace("zero instances, closing helper {}", (Object)helper);
                helper.close();
                helper = null;
                wasClosed = true;
            }
            if (instanceCount < 0) {
                logger.error("too many calls to release helper, instance count = {}", (Object)instanceCount);
            }
        }
    }

    private static void innerSetHelperClass(Class<? extends OrmLiteSqliteOpenHelper> openHelperClass) {
        if (helperClass == null) {
            helperClass = openHelperClass;
        } else if (helperClass != openHelperClass) {
            throw new IllegalStateException("Helper class was " + helperClass + " but is trying to be reset to " + openHelperClass);
        }
    }

    private static <T extends OrmLiteSqliteOpenHelper> T loadHelper(Context context, Class<T> openHelperClass) {
        if (helper == null) {
            if (wasClosed) {
                logger.info("helper was already closed and is being re-opened");
            }
            if (context == null) {
                throw new IllegalArgumentException("context argument is null");
            }
            Context appContext = context.getApplicationContext();
            helper = OpenHelperManager.constructHelper(appContext, helperClass);
            logger.trace("zero instances, created helper {}", (Object)helper);
            BaseDaoImpl.clearAllInternalObjectCaches();
            DaoManager.clearCache();
            instanceCount = 0;
        }
        logger.trace("returning helper {}, instance count = {} ", (Object)helper, (Object)(++instanceCount));
        OrmLiteSqliteOpenHelper castHelper = helper;
        return (T)((Object)castHelper);
    }

    private static OrmLiteSqliteOpenHelper constructHelper(Context context, Class<? extends OrmLiteSqliteOpenHelper> openHelperClass) {
        Constructor<? extends OrmLiteSqliteOpenHelper> constructor;
        try {
            constructor = openHelperClass.getConstructor(Context.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not find constructor that takes a Context argument for helper class " + openHelperClass, e);
        }
        try {
            return constructor.newInstance(context);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not construct instance of helper class " + openHelperClass, e);
        }
    }

    private static Class<? extends OrmLiteSqliteOpenHelper> lookupHelperClass(Context context, Class<?> componentClass) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier(HELPER_CLASS_RESOURCE_NAME, "string", context.getPackageName());
        if (resourceId != 0) {
            String className = resources.getString(resourceId);
            try {
                Class<?> castClass = Class.forName(className);
                return castClass;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create helper instance for class " + className, e);
            }
        }
        for (Class<?> componentClassWalk = componentClass; componentClassWalk != null; componentClassWalk = componentClassWalk.getSuperclass()) {
            Type[] types;
            Type superType = componentClassWalk.getGenericSuperclass();
            if (superType == null || !(superType instanceof ParameterizedType) || (types = ((ParameterizedType)superType).getActualTypeArguments()) == null || types.length == 0) continue;
            for (Type type : types) {
                Class clazz;
                if (!(type instanceof Class) || !OrmLiteSqliteOpenHelper.class.isAssignableFrom(clazz = (Class)type)) continue;
                Class castOpenHelperClass = clazz;
                return castOpenHelperClass;
            }
        }
        throw new IllegalStateException("Could not find OpenHelperClass because none of the generic parameters of class " + componentClass + " extends OrmLiteSqliteOpenHelper.  You should use getHelper(Context, Class) instead.");
    }
}

