/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.Cursor;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.SqliteAndroidDatabaseType;
import com.j256.ormlite.support.DatabaseResults;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Timestamp;

public class AndroidDatabaseResults
implements DatabaseResults {
    private final Cursor cursor;
    private final ObjectCache objectCache;
    private boolean firstCall;
    private static final DatabaseType databaseType = new SqliteAndroidDatabaseType();

    public AndroidDatabaseResults(Cursor cursor, ObjectCache objectCache) {
        this(cursor, true, objectCache);
    }

    public AndroidDatabaseResults(Cursor cursor, boolean firstCall, ObjectCache objectCache) {
        this.cursor = cursor;
        this.firstCall = firstCall;
        this.objectCache = objectCache;
    }

    public int getColumnCount() throws SQLException {
        return this.cursor.getColumnCount();
    }

    public boolean next() throws SQLException {
        boolean returnValue;
        if (this.firstCall) {
            returnValue = this.cursor.moveToFirst();
            this.firstCall = false;
        } else {
            returnValue = this.cursor.moveToNext();
        }
        return returnValue;
    }

    public int findColumn(String columnName) throws SQLException {
        int index = this.cursor.getColumnIndex(columnName);
        if (index < 0) {
            StringBuilder sb = new StringBuilder(columnName.length() + 4);
            databaseType.appendEscapedEntityName(sb, columnName);
            index = this.cursor.getColumnIndex(sb.toString());
            if (index < 0) {
                throw new SQLException("Unknown field '" + columnName + "' from the Android sqlite cursor");
            }
        }
        return index;
    }

    public String getString(int columnIndex) throws SQLException {
        return this.cursor.getString(columnIndex);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return !this.cursor.isNull(columnIndex) && this.cursor.getShort(columnIndex) != 0;
    }

    public char getChar(int columnIndex) throws SQLException {
        String string = this.cursor.getString(columnIndex);
        if (string == null || string.length() == 0) {
            return '\u0000';
        }
        if (string.length() == 1) {
            return string.charAt(0);
        }
        throw new SQLException("More than 1 character stored in database column: " + columnIndex);
    }

    public byte getByte(int columnIndex) throws SQLException {
        return (byte)this.getShort(columnIndex);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.cursor.getBlob(columnIndex);
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.cursor.getShort(columnIndex);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.cursor.getInt(columnIndex);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.cursor.getLong(columnIndex);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.cursor.getFloat(columnIndex);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.cursor.getDouble(columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw new SQLException("Android does not support timestamp.  Use JAVA_DATE_LONG or JAVA_DATE_STRING types");
    }

    public InputStream getBlobStream(int columnIndex) throws SQLException {
        return new ByteArrayInputStream(this.cursor.getBlob(columnIndex));
    }

    public boolean wasNull(int columnIndex) throws SQLException {
        return this.cursor.isNull(columnIndex);
    }

    public ObjectCache getObjectCache() {
        return this.objectCache;
    }

    public Cursor getRawCursor() {
        return this.cursor;
    }
}

