/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.query;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.query.Clause;
import com.j256.ormlite.stmt.query.NeedsFutureClause;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseBinaryClause
implements NeedsFutureClause {
    private Clause left;
    private Clause right = null;

    protected BaseBinaryClause(Clause left) {
        this.left = left;
    }

    protected BaseBinaryClause(Clause left, Clause right) {
        this.left = left;
        this.right = right;
    }

    public abstract StringBuilder appendOperation(StringBuilder var1);

    @Override
    public StringBuilder appendSql(DatabaseType databaseType, StringBuilder sb, List<SelectArg> columnArgList) throws SQLException {
        sb.append("(");
        this.left.appendSql(databaseType, sb, columnArgList);
        this.appendOperation(sb);
        this.right.appendSql(databaseType, sb, columnArgList);
        sb.append(") ");
        return sb;
    }

    @Override
    public void setMissingClause(Clause right) {
        if (this.right != null) {
            throw new IllegalStateException("Operation already has a right side set: " + this);
        }
        this.right = right;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.left).append(' ');
        this.appendOperation(sb);
        sb.append(this.right);
        return sb.toString();
    }
}

