/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import com.j256.ormlite.android.AndroidDatabaseResults;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseResults;
import java.util.ArrayList;
import java.util.List;

public class AndroidCompiledStatement
implements CompiledStatement {
    private final String sql;
    private final SQLiteDatabase db;
    private final StatementBuilder.StatementType type;
    private Cursor cursor;
    private final List<Object> args = new ArrayList<Object>();
    private Integer max;

    public AndroidCompiledStatement(String sql, SQLiteDatabase db, StatementBuilder.StatementType type) {
        this.sql = sql;
        this.db = db;
        this.type = type;
    }

    public int getColumnCount() throws java.sql.SQLException {
        return this.getCursor().getColumnCount();
    }

    public String getColumnName(int column) throws java.sql.SQLException {
        return this.getCursor().getColumnName(AndroidDatabaseResults.jdbcColumnIndexToAndroid(column));
    }

    public DatabaseResults executeQuery() throws java.sql.SQLException {
        if (this.type != StatementBuilder.StatementType.SELECT) {
            throw new IllegalArgumentException("Cannot call executeQuery on a " + this.type + " statement");
        }
        return new AndroidDatabaseResults(this.getCursor());
    }

    public int executeUpdate() throws java.sql.SQLException {
        if (this.type == StatementBuilder.StatementType.SELECT) {
            throw new IllegalArgumentException("Cannot call executeUpdate on a " + this.type + " statement");
        }
        String finalSql = null;
        try {
            finalSql = this.max == null ? this.sql : this.sql + " " + this.max;
            this.db.execSQL(finalSql, this.args.toArray(new Object[this.args.size()]));
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("Problems executing Android statement: " + finalSql), (Throwable)e);
        }
        return 1;
    }

    public DatabaseResults getGeneratedKeys() throws java.sql.SQLException {
        throw new UnsupportedOperationException("Unsupported operation to getGeneratedKeys");
    }

    public void close() throws java.sql.SQLException {
        if (this.cursor != null) {
            try {
                this.cursor.close();
            }
            catch (SQLException e) {
                throw SqlExceptionUtil.create((String)"Problems closing Android cursor", (Throwable)e);
            }
        }
    }

    public void setNull(int parameterIndex, SqlType sqlType) throws java.sql.SQLException {
        this.isInPrep();
        this.args.add(AndroidDatabaseResults.jdbcColumnIndexToAndroid(parameterIndex), null);
    }

    public void setObject(int parameterIndex, Object obj, SqlType sqlType) throws java.sql.SQLException {
        this.isInPrep();
        this.args.add(AndroidDatabaseResults.jdbcColumnIndexToAndroid(parameterIndex), obj.toString());
    }

    public void setMaxRows(int max) throws java.sql.SQLException {
        this.isInPrep();
        this.max = max;
    }

    public Cursor getCursor() throws java.sql.SQLException {
        if (this.cursor == null) {
            String finalSql = null;
            try {
                finalSql = this.max == null ? this.sql : this.sql + " " + this.max;
                this.cursor = this.db.rawQuery(finalSql, this.args.toArray(new String[this.args.size()]));
                this.cursor.moveToFirst();
            }
            catch (SQLException e) {
                throw SqlExceptionUtil.create((String)("Problems executing Android query: " + finalSql), (Throwable)e);
            }
        }
        return this.cursor;
    }

    private void isInPrep() throws java.sql.SQLException {
        if (this.cursor != null) {
            throw new java.sql.SQLException("Query already run. Cannot add argument values.");
        }
    }
}

