/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.stmt.PreparedStmt;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.stmt.mapped.MappedPreparedStmt;
import com.j256.ormlite.stmt.query.OrderBy;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementBuilder<T, ID> {
    private static Logger logger = LoggerFactory.getLogger(StatementBuilder.class);
    private TableInfo<T> tableInfo;
    private DatabaseType databaseType;
    private final FieldType idField;
    private boolean distinct = false;
    private boolean selectIdColumn = true;
    private List<String> columnList = null;
    private List<OrderBy> orderByList = null;
    private List<String> groupByList = null;
    private Where where = null;
    private Integer limit = null;

    public StatementBuilder(DatabaseType databaseType, TableInfo<T> tableInfo) {
        this.databaseType = databaseType;
        this.tableInfo = tableInfo;
        this.idField = tableInfo.getIdField();
    }

    public StatementBuilder<T, ID> columns(String ... columns) {
        if (this.columnList == null) {
            this.columnList = new ArrayList<String>();
        }
        for (String column : columns) {
            this.addColumnToList(column);
        }
        return this;
    }

    public StatementBuilder<T, ID> columns(Iterable<String> columns) {
        if (this.columnList == null) {
            this.columnList = new ArrayList<String>();
        }
        for (String column : columns) {
            this.addColumnToList(column);
        }
        return this;
    }

    public StatementBuilder<T, ID> groupBy(String columnName) {
        this.verifyColumnName(columnName);
        if (this.groupByList == null) {
            this.groupByList = new ArrayList<String>();
        }
        this.groupByList.add(columnName);
        this.selectIdColumn = false;
        return this;
    }

    public StatementBuilder<T, ID> orderBy(String columnName, boolean ascending) {
        this.verifyColumnName(columnName);
        if (this.orderByList == null) {
            this.orderByList = new ArrayList<OrderBy>();
        }
        this.orderByList.add(new OrderBy(columnName, ascending));
        return this;
    }

    public StatementBuilder<T, ID> distinct() {
        this.distinct = true;
        this.selectIdColumn = false;
        return this;
    }

    public StatementBuilder<T, ID> limit(Integer maxRows) {
        this.limit = maxRows;
        return this;
    }

    public Where where() {
        this.where = new Where(this.tableInfo);
        return this.where;
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    public PreparedStmt<T> prepareStatement() throws SQLException {
        ArrayList<FieldType> argFieldTypeList = new ArrayList<FieldType>();
        ArrayList<FieldType> resultFieldTypeList = new ArrayList<FieldType>();
        ArrayList<SelectArg> selectArgList = new ArrayList<SelectArg>();
        String statement = this.buildSelectString(argFieldTypeList, resultFieldTypeList, selectArgList);
        return new MappedPreparedStmt<T>(this.tableInfo, statement, argFieldTypeList, resultFieldTypeList, selectArgList, this.databaseType.isLimitSqlSupported() ? null : this.limit);
    }

    @Deprecated
    public PreparedStmt<T> prepareQuery() throws SQLException {
        return this.prepareStatement();
    }

    public String prepareStatementString() throws SQLException {
        ArrayList<FieldType> argFieldTypeList = new ArrayList<FieldType>();
        ArrayList<FieldType> resultFieldTypeList = new ArrayList<FieldType>();
        ArrayList<SelectArg> selectArgList = new ArrayList<SelectArg>();
        return this.buildSelectString(argFieldTypeList, resultFieldTypeList, selectArgList);
    }

    private String buildSelectString(List<FieldType> argFieldTypeList, List<FieldType> resultFieldTypeList, List<SelectArg> selectArgList) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (this.databaseType.isLimitAfterSelect()) {
            this.appendLimit(sb);
        }
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        this.appendColumns(sb, resultFieldTypeList);
        sb.append("FROM ");
        this.databaseType.appendEscapedEntityName(sb, this.tableInfo.getTableName());
        sb.append(' ');
        if (this.where != null) {
            sb.append("WHERE ");
            this.where.appendSql(this.databaseType, sb, selectArgList);
        }
        for (SelectArg selectArg : selectArgList) {
            FieldType fieldType = this.tableInfo.getFieldTypeByName(selectArg.getColumnName());
            argFieldTypeList.add(fieldType);
        }
        this.appendGroupBys(sb);
        this.appendOrderBys(sb);
        if (!this.databaseType.isLimitAfterSelect()) {
            this.appendLimit(sb);
        }
        String statement = sb.toString();
        logger.debug("built statement {}", statement);
        return statement;
    }

    private void addColumnToList(String column) {
        this.verifyColumnName(column);
        this.columnList.add(column);
    }

    private void verifyColumnName(String columnName) {
        if (this.tableInfo.getFieldTypeByName(columnName) == null) {
            throw new IllegalArgumentException("Unknown column-name " + columnName);
        }
    }

    private void appendColumns(StringBuilder sb, List<FieldType> fieldTypeList) {
        if (this.columnList == null) {
            sb.append("* ");
            for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
                fieldTypeList.add(fieldType);
            }
            return;
        }
        boolean first = true;
        boolean hasId = false;
        for (String columnName : this.columnList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            FieldType fieldType = this.tableInfo.getFieldTypeByName(columnName);
            this.appendFieldColumnName(sb, fieldType, fieldTypeList);
            if (fieldType != this.idField) continue;
            hasId = true;
        }
        if (!hasId && this.selectIdColumn) {
            if (!first) {
                sb.append(',');
            }
            this.appendFieldColumnName(sb, this.idField, fieldTypeList);
        }
        sb.append(' ');
    }

    private void appendFieldColumnName(StringBuilder sb, FieldType fieldType, List<FieldType> fieldTypeList) {
        this.databaseType.appendEscapedEntityName(sb, fieldType.getDbColumnName());
        if (fieldTypeList != null) {
            fieldTypeList.add(fieldType);
        }
    }

    private void appendGroupBys(StringBuilder sb) {
        if (this.groupByList == null || this.groupByList.size() == 0) {
            return;
        }
        sb.append("GROUP BY ");
        boolean first = true;
        for (String columnName : this.groupByList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            this.databaseType.appendEscapedEntityName(sb, columnName);
        }
        sb.append(' ');
    }

    private void appendOrderBys(StringBuilder sb) {
        if (this.orderByList == null || this.orderByList.size() == 0) {
            return;
        }
        sb.append("ORDER BY ");
        boolean first = true;
        for (OrderBy orderBy : this.orderByList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            String columnName = orderBy.getColumnName();
            this.verifyColumnName(columnName);
            this.databaseType.appendEscapedEntityName(sb, columnName);
            if (orderBy.isAscending()) continue;
            sb.append(" DESC");
        }
        sb.append(' ');
    }

    private void appendLimit(StringBuilder sb) {
        if (this.limit != null && this.databaseType.isLimitSqlSupported()) {
            this.databaseType.appendLimitValue(sb, this.limit);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InternalQueryBuilder<T, ID>
    extends StatementBuilder<T, ID> {
        public InternalQueryBuilder(DatabaseType databaseType, TableInfo<T> tableInfo) {
            super(databaseType, tableInfo);
        }

        @Override
        public String buildSelectString(List<FieldType> argFieldTypeList, List<FieldType> resultFieldTypeList, List<SelectArg> selectArgList) throws SQLException {
            return ((StatementBuilder)this).buildSelectString(argFieldTypeList, resultFieldTypeList, selectArgList);
        }
    }
}

