/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.RawResults;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.PreparedStmt;
import com.j256.ormlite.stmt.SelectIterator;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.StatementExecutor;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDaoImpl<T, ID>
implements Dao<T, ID> {
    private DatabaseType databaseType;
    private ConnectionSource connectionSource;
    private final Class<T> dataClass;
    private DatabaseTableConfig<T> tableConfig;
    private TableInfo<T> tableInfo;
    private StatementExecutor<T, ID> statementExecutor;
    private boolean initialized = false;

    protected BaseDaoImpl(Class<T> dataClass) {
        this(null, dataClass, null);
    }

    protected BaseDaoImpl(DatabaseType databaseType, Class<T> dataClass) {
        this(databaseType, dataClass, null);
    }

    protected BaseDaoImpl(DatabaseTableConfig<T> tableConfig) {
        this(null, tableConfig.getDataClass(), tableConfig);
    }

    protected BaseDaoImpl(DatabaseType databaseType, DatabaseTableConfig<T> tableConfig) {
        this(databaseType, tableConfig.getDataClass(), tableConfig);
    }

    private BaseDaoImpl(DatabaseType databaseType, Class<T> dataClass, DatabaseTableConfig<T> tableConfig) {
        this.databaseType = databaseType;
        this.dataClass = dataClass;
        this.tableConfig = tableConfig;
    }

    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        if (this.databaseType == null) {
            throw new IllegalStateException("databaseType was never set on " + this.getClass().getSimpleName());
        }
        if (this.connectionSource == null) {
            throw new IllegalStateException("connectionSource was never set on " + this.getClass().getSimpleName());
        }
        if (this.tableConfig == null) {
            this.tableConfig = DatabaseTableConfig.fromClass(this.databaseType, this.dataClass);
        }
        this.tableInfo = new TableInfo<T>(this.databaseType, this.tableConfig);
        this.statementExecutor = new StatementExecutor(this.databaseType, this.tableInfo);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T queryForId(ID id) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection();
        try {
            T t = this.statementExecutor.queryForId(connection, id);
            return t;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T queryForFirst(PreparedStmt<T> preparedStmt) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection();
        try {
            T t = this.statementExecutor.queryForFirst(connection, preparedStmt);
            return t;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public List<T> queryForAll() throws SQLException {
        this.checkForInitialized();
        return this.statementExecutor.queryForAll(this.connectionSource);
    }

    @Override
    public StatementBuilder<T, ID> statementBuilder() {
        this.checkForInitialized();
        return new StatementBuilder(this.databaseType, this.tableInfo);
    }

    @Override
    @Deprecated
    public StatementBuilder<T, ID> queryBuilder() {
        this.checkForInitialized();
        return this.statementBuilder();
    }

    @Override
    public List<T> query(PreparedStmt<T> preparedStmt) throws SQLException {
        this.checkForInitialized();
        return this.statementExecutor.query(this.connectionSource, preparedStmt);
    }

    @Override
    public RawResults queryForAllRaw(String queryString) throws SQLException {
        this.checkForInitialized();
        return this.statementExecutor.queryRaw(this.connectionSource, queryString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int create(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.create(connection, data);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.update(connection, data);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateId(T data, ID newId) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.updateId(connection, data, newId);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int refresh(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection();
        try {
            int n = this.statementExecutor.refresh(connection, data);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.delete(connection, data);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(Collection<T> datas) throws SQLException {
        this.checkForInitialized();
        if (datas == null || datas.size() == 0) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.deleteObjects(connection, datas);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteIds(Collection<ID> ids) throws SQLException {
        this.checkForInitialized();
        if (ids == null || ids.size() == 0) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.deleteIds(connection, ids);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    public SelectIterator<T, ID> iterator() {
        this.checkForInitialized();
        try {
            return this.statementExecutor.buildIterator(this, this.connectionSource);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not build iterator for " + this.dataClass, e);
        }
    }

    public SelectIterator<T, ID> iterator(PreparedStmt<T> preparedQuery) throws SQLException {
        this.checkForInitialized();
        try {
            return this.statementExecutor.buildIterator(this, this.connectionSource, preparedQuery);
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Could not build iterator for " + this.dataClass, e);
        }
    }

    @Override
    public RawResults iteratorRaw(String query) throws SQLException {
        this.checkForInitialized();
        try {
            return this.statementExecutor.buildIterator(this.connectionSource, query);
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Could not build iterator for " + query, e);
        }
    }

    @Override
    public String objectToString(T data) {
        this.checkForInitialized();
        return this.tableInfo.objectToString(data);
    }

    @Override
    public boolean objectsEqual(T data1, T data2) throws SQLException {
        this.checkForInitialized();
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            Object fieldObj1 = fieldType.getFieldValue(data1);
            Object fieldObj2 = fieldType.getFieldValue(data2);
            if (fieldObj1 == null) {
                if (fieldObj2 == null) continue;
                return false;
            }
            if (fieldObj2 == null) {
                return false;
            }
            if (fieldObj1.equals(fieldObj2)) continue;
            return false;
        }
        return true;
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public DatabaseTableConfig<T> getTableConfig() {
        return this.tableConfig;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    public void setTableConfig(DatabaseTableConfig<T> tableConfig) {
        this.tableConfig = tableConfig;
    }

    public static <T, ID> Dao<T, ID> createDao(DatabaseType databaseType, ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        BaseDaoImpl dao = new BaseDaoImpl<T, ID>(databaseType, (Class)clazz){};
        dao.setConnectionSource(connectionSource);
        dao.initialize();
        return dao;
    }

    private void checkForInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("you must call initialize() before you can use the dao");
        }
    }
}

