/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.android.AndroidLog;
import com.j256.ormlite.logger.CommonsLoggingLog;
import com.j256.ormlite.logger.LocalLog;
import com.j256.ormlite.logger.Log;
import com.j256.ormlite.logger.Log4jLog;
import com.j256.ormlite.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerFactory {
    private static LogType logType;

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String className) {
        Log log = null;
        if (logType == null) {
            logType = LoggerFactory.findLogType();
        }
        switch (logType) {
            case COMMONS_LOGGING: {
                log = new CommonsLoggingLog(className);
                break;
            }
            case LOG4J: {
                log = new Log4jLog(className);
                break;
            }
            case ANDROID: {
                log = new AndroidLog(className);
                break;
            }
            case LOCAL: {
                log = new LocalLog(className);
            }
        }
        return new Logger(log);
    }

    public static String getSimpleClassName(String className) {
        String[] parts = className.split("\\.");
        if (parts.length == 0) {
            return className;
        }
        return parts[parts.length - 1];
    }

    private static LogType findLogType() {
        if (LoggerFactory.checkClass("org.apache.commons.logging.LogFactory")) {
            return LogType.COMMONS_LOGGING;
        }
        if (LoggerFactory.checkClass("org.apache.log4j.Logger")) {
            return LogType.LOG4J;
        }
        if (LoggerFactory.checkClass("android.util.Log")) {
            return LogType.ANDROID;
        }
        return LogType.LOCAL;
    }

    private static boolean checkClass(String classPath) {
        try {
            Class.forName(classPath);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LogType {
        COMMONS_LOGGING,
        LOG4J,
        ANDROID,
        LOCAL;

    }
}

