/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.PermissionData;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysTenant;
import org.jeecg.modules.system.service.ISysTenantService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/tenant"})
public class SysTenantController {
    private static final Logger log = LoggerFactory.getLogger(SysTenantController.class);
    @Autowired
    private ISysTenantService sysTenantService;

    @PermissionData(pageComponent="system/TenantList")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<SysTenant>> queryPageList(SysTenant sysTenant, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<SysTenant>> result = new Result<IPage<SysTenant>>();
        QueryWrapper<SysTenant> queryWrapper = QueryGenerator.initQueryWrapper(sysTenant, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysTenantService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<SysTenant> add(@RequestBody SysTenant sysTenant) {
        Result<SysTenant> result = new Result<SysTenant>();
        if (this.sysTenantService.getById(sysTenant.getId()) != null) {
            return result.error500("\u8be5\u7f16\u53f7\u5df2\u5b58\u5728!");
        }
        try {
            this.sysTenantService.save(sysTenant);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT})
    public Result<SysTenant> edit(@RequestBody SysTenant tenant) {
        Result<SysTenant> result = new Result<SysTenant>();
        SysTenant sysTenant = (SysTenant)this.sysTenantService.getById(tenant.getId());
        if (sysTenant == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.sysTenantService.updateById(tenant);
            if (ok) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.sysTenantService.removeById((Serializable)((Object)id));
        return Result.ok("\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (oConvertUtils.isEmpty(ids)) {
            result.error500("\u672a\u9009\u4e2d\u79df\u6237\uff01");
        } else {
            List<String> ls = Arrays.asList(ids.split(","));
            this.sysTenantService.removeByIds(ls);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<SysTenant> queryById(@RequestParam(name="id", required=true) String id) {
        Result<SysTenant> result = new Result<SysTenant>();
        SysTenant sysTenant = (SysTenant)this.sysTenantService.getById((Serializable)((Object)id));
        if (sysTenant == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult(sysTenant);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET})
    public Result<List<SysTenant>> queryList(@RequestParam(name="ids", required=false) String ids) {
        Result<List<SysTenant>> result = new Result<List<SysTenant>>();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysTenant::getStatus, (Object)1);
        if (oConvertUtils.isNotEmpty(ids)) {
            query.in(SysTenant::getId, (Object[])ids.split(","));
        }
        Date now = new Date();
        query.ge(SysTenant::getEndDate, (Object)now);
        query.le(SysTenant::getBeginDate, (Object)now);
        List ls = this.sysTenantService.list((Wrapper)query);
        result.setSuccess(true);
        result.setResult(ls);
        return result;
    }
}

