/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.entity.SysPermissionDataRule;
import org.jeecg.modules.system.entity.SysRole;
import org.jeecg.modules.system.entity.SysRolePermission;
import org.jeecg.modules.system.model.TreeModel;
import org.jeecg.modules.system.service.ISysPermissionDataRuleService;
import org.jeecg.modules.system.service.ISysPermissionService;
import org.jeecg.modules.system.service.ISysRolePermissionService;
import org.jeecg.modules.system.service.ISysRoleService;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/role"})
public class SysRoleController {
    private static final Logger log = LoggerFactory.getLogger(SysRoleController.class);
    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private ISysPermissionDataRuleService sysPermissionDataRuleService;
    @Autowired
    private ISysRolePermissionService sysRolePermissionService;
    @Autowired
    private ISysPermissionService sysPermissionService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<SysRole>> queryPageList(SysRole role, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<SysRole>> result = new Result<IPage<SysRole>>();
        QueryWrapper<SysRole> queryWrapper = QueryGenerator.initQueryWrapper(role, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysRoleService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<SysRole> add(@RequestBody SysRole role) {
        Result<SysRole> result = new Result<SysRole>();
        try {
            role.setCreateTime(new Date());
            this.sysRoleService.save(role);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT})
    public Result<SysRole> edit(@RequestBody SysRole role) {
        Result<SysRole> result = new Result<SysRole>();
        SysRole sysrole = (SysRole)this.sysRoleService.getById((Serializable)((Object)role.getId()));
        if (sysrole == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            role.setUpdateTime(new Date());
            boolean ok = this.sysRoleService.updateById(role);
            if (ok) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.sysRoleService.deleteRole(id);
        return Result.ok("\u5220\u9664\u89d2\u8272\u6210\u529f");
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    public Result<SysRole> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result<SysRole> result = new Result<SysRole>();
        if (oConvertUtils.isEmpty(ids)) {
            result.error500("\u672a\u9009\u4e2d\u89d2\u8272\uff01");
        } else {
            this.sysRoleService.deleteBatchRole(ids.split(","));
            result.success("\u5220\u9664\u89d2\u8272\u6210\u529f!");
        }
        return result;
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<SysRole> queryById(@RequestParam(name="id", required=true) String id) {
        Result<SysRole> result = new Result<SysRole>();
        SysRole sysrole = (SysRole)this.sysRoleService.getById((Serializable)((Object)id));
        if (sysrole == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult(sysrole);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/queryall"}, method={RequestMethod.GET})
    public Result<List<SysRole>> queryall() {
        Result<List<SysRole>> result = new Result<List<SysRole>>();
        List list = this.sysRoleService.list();
        if (list == null || list.size() <= 0) {
            result.error500("\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f");
        } else {
            result.setResult(list);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/checkRoleCode"}, method={RequestMethod.GET})
    public Result<Boolean> checkUsername(String id, String roleCode) {
        Result<Boolean> result = new Result<Boolean>();
        result.setResult(true);
        log.info("--\u9a8c\u8bc1\u89d2\u8272\u7f16\u7801\u662f\u5426\u552f\u4e00---id:" + id + "--roleCode:" + roleCode);
        try {
            SysRole newRole;
            SysRole role = null;
            if (oConvertUtils.isNotEmpty(id)) {
                role = (SysRole)this.sysRoleService.getById((Serializable)((Object)id));
            }
            if ((newRole = (SysRole)this.sysRoleService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysRole::getRoleCode, (Object)roleCode))) != null) {
                if (role == null) {
                    result.setSuccess(false);
                    result.setMessage("\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
                    return result;
                }
                if (!id.equals(newRole.getId())) {
                    result.setSuccess(false);
                    result.setMessage("\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
                    return result;
                }
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setResult(false);
            result.setMessage(e.getMessage());
            return result;
        }
        result.setSuccess(true);
        return result;
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(SysRole sysRole, HttpServletRequest request) {
        QueryWrapper<SysRole> queryWrapper = QueryGenerator.initQueryWrapper(sysRole, request.getParameterMap());
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        List pageList = this.sysRoleService.list((Wrapper)queryWrapper);
        mv.addObject("fileName", (Object)"\u89d2\u8272\u5217\u8868");
        mv.addObject("entity", SysRole.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        mv.addObject("params", (Object)new ExportParams("\u89d2\u8272\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f"));
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                Result result = this.sysRoleService.importExcelCheckRoleCode(file, params);
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result<Object> result = Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @GetMapping(value={"/datarule/{permissionId}/{roleId}"})
    public Result<?> loadDatarule(@PathVariable(value="permissionId") String permissionId, @PathVariable(value="roleId") String roleId) {
        String drChecked;
        List<SysPermissionDataRule> list = this.sysPermissionDataRuleService.getPermRuleListByPermId(permissionId);
        if (list == null || list.size() == 0) {
            return Result.error("\u672a\u627e\u5230\u6743\u9650\u914d\u7f6e\u4fe1\u606f");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datarule", list);
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRolePermission::getPermissionId, (Object)permissionId)).isNotNull(SysRolePermission::getDataRuleIds)).eq(SysRolePermission::getRoleId, (Object)roleId);
        SysRolePermission sysRolePermission = (SysRolePermission)this.sysRolePermissionService.getOne((Wrapper)query);
        if (sysRolePermission != null && oConvertUtils.isNotEmpty(drChecked = sysRolePermission.getDataRuleIds())) {
            map.put("drChecked", drChecked.endsWith(",") ? drChecked.substring(0, drChecked.length() - 1) : drChecked);
        }
        return Result.ok(map);
    }

    @PostMapping(value={"/datarule"})
    public Result<?> saveDatarule(@RequestBody JSONObject jsonObject) {
        try {
            String permissionId = jsonObject.getString("permissionId");
            String roleId = jsonObject.getString("roleId");
            String dataRuleIds = jsonObject.getString("dataRuleIds");
            log.info("\u4fdd\u5b58\u6570\u636e\u89c4\u5219>>\u83dc\u5355ID:" + permissionId + "\u89d2\u8272ID:" + roleId + "\u6570\u636e\u6743\u9650ID:" + dataRuleIds);
            LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRolePermission::getPermissionId, (Object)permissionId)).eq(SysRolePermission::getRoleId, (Object)roleId);
            SysRolePermission sysRolePermission = (SysRolePermission)this.sysRolePermissionService.getOne((Wrapper)query);
            if (sysRolePermission == null) {
                return Result.error("\u8bf7\u5148\u4fdd\u5b58\u89d2\u8272\u83dc\u5355\u6743\u9650!");
            }
            sysRolePermission.setDataRuleIds(dataRuleIds);
            this.sysRolePermissionService.updateById(sysRolePermission);
        }
        catch (Exception e) {
            log.error("SysRoleController.saveDatarule()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return Result.error("\u4fdd\u5b58\u5931\u8d25");
        }
        return Result.ok("\u4fdd\u5b58\u6210\u529f!");
    }

    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> queryTreeList(HttpServletRequest request) {
        Result<Map<String, Object>> result = new Result<Map<String, Object>>();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysPermission::getDelFlag, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(SysPermission::getSortNo);
            List list = this.sysPermissionService.list((Wrapper)query);
            for (SysPermission sysPer : list) {
                ids.add(sysPer.getId());
            }
            ArrayList<TreeModel> treeList = new ArrayList<TreeModel>();
            this.getTreeModelList(treeList, list, null);
            HashMap<String, ArrayList<Object>> resMap = new HashMap<String, ArrayList<Object>>();
            resMap.put("treeList", treeList);
            resMap.put("ids", ids);
            result.setResult(resMap);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void getTreeModelList(List<TreeModel> treeList, List<SysPermission> metaList, TreeModel temp) {
        for (SysPermission permission : metaList) {
            String tempPid = permission.getParentId();
            TreeModel tree = new TreeModel(permission.getId(), tempPid, permission.getName(), permission.getRuleFlag(), permission.isLeaf());
            if (temp == null && oConvertUtils.isEmpty(tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeModelList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getKey())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeModelList(treeList, metaList, tree);
        }
    }
}

