/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.ngalain.aop;

import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class LogRecordAspect {
    private static final Logger logger = LoggerFactory.getLogger(LogRecordAspect.class);

    @Pointcut(value="execution(public * org.jeecg.modules.*.*.*Controller.*(..))")
    public void excudeService() {
    }

    @Around(value="excudeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String uri = request.getRequestURI();
        String queryString = request.getQueryString();
        logger.info("\u8bf7\u6c42\u5f00\u59cb, \u5404\u4e2a\u53c2\u6570, url: {}, method: {}, uri: {}, params: {}", new Object[]{url, method, uri, queryString});
        Object result = pjp.proceed();
        logger.info("\u8bf7\u6c42\u7ed3\u675f\uff0ccontroller\u7684\u8fd4\u56de\u503c\u662f " + result);
        return result;
    }
}

