/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.message.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.message.entity.MsgParams;
import org.jeecg.modules.message.entity.SysMessageTemplate;
import org.jeecg.modules.message.service.ISysMessageTemplateService;
import org.jeecg.modules.message.util.PushMsgUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/message/sysMessageTemplate"})
public class SysMessageTemplateController
extends JeecgController<SysMessageTemplate, ISysMessageTemplateService> {
    private static final Logger log = LoggerFactory.getLogger(SysMessageTemplateController.class);
    @Autowired
    private ISysMessageTemplateService sysMessageTemplateService;
    @Autowired
    private PushMsgUtil pushMsgUtil;

    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SysMessageTemplate sysMessageTemplate, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<SysMessageTemplate> queryWrapper = QueryGenerator.initQueryWrapper(sysMessageTemplate, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysMessageTemplateService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SysMessageTemplate sysMessageTemplate) {
        this.sysMessageTemplateService.save(sysMessageTemplate);
        return Result.ok("\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @PutMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SysMessageTemplate sysMessageTemplate) {
        this.sysMessageTemplateService.updateById(sysMessageTemplate);
        return Result.ok("\u66f4\u65b0\u6210\u529f\uff01");
    }

    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.sysMessageTemplateService.removeById((Serializable)((Object)id));
        return Result.ok("\u5220\u9664\u6210\u529f!");
    }

    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.sysMessageTemplateService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.ok("\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SysMessageTemplate sysMessageTemplate = (SysMessageTemplate)this.sysMessageTemplateService.getById((Serializable)((Object)id));
        return Result.ok(sysMessageTemplate);
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SysMessageTemplate sysMessageTemplate) {
        return super.exportXls(request, sysMessageTemplate, SysMessageTemplate.class, "\u63a8\u9001\u6d88\u606f\u6a21\u677f");
    }

    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SysMessageTemplate.class);
    }

    @PostMapping(value={"/sendMsg"})
    public Result<SysMessageTemplate> sendMessage(@RequestBody MsgParams msgParams) {
        Result<SysMessageTemplate> result = new Result<SysMessageTemplate>();
        Map map = null;
        try {
            map = (Map)JSON.parse((String)msgParams.getTestData());
        }
        catch (Exception e) {
            result.error500("\u89e3\u6790Json\u51fa\u9519\uff01");
            return result;
        }
        boolean is_sendSuccess = this.pushMsgUtil.sendMessage(msgParams.getMsgType(), msgParams.getTemplateCode(), map, msgParams.getReceiver());
        if (is_sendSuccess) {
            result.success("\u53d1\u9001\u6d88\u606f\u4efb\u52a1\u6dfb\u52a0\u6210\u529f\uff01");
        } else {
            result.error500("\u53d1\u9001\u6d88\u606f\u4efb\u52a1\u6dfb\u52a0\u5931\u8d25\uff01");
        }
        return result;
    }
}

