/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.test.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.jeecg.modules.demo.test.entity.JeecgOrderCustomer;
import org.jeecg.modules.demo.test.entity.JeecgOrderMain;
import org.jeecg.modules.demo.test.entity.JeecgOrderTicket;
import org.jeecg.modules.demo.test.mapper.JeecgOrderCustomerMapper;
import org.jeecg.modules.demo.test.mapper.JeecgOrderMainMapper;
import org.jeecg.modules.demo.test.mapper.JeecgOrderTicketMapper;
import org.jeecg.modules.demo.test.service.IJeecgOrderMainService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JeecgOrderMainServiceImpl
extends ServiceImpl<JeecgOrderMainMapper, JeecgOrderMain>
implements IJeecgOrderMainService {
    @Autowired
    private JeecgOrderMainMapper jeecgOrderMainMapper;
    @Autowired
    private JeecgOrderCustomerMapper jeecgOrderCustomerMapper;
    @Autowired
    private JeecgOrderTicketMapper jeecgOrderTicketMapper;

    @Override
    @Transactional
    public void saveMain(JeecgOrderMain jeecgOrderMain, List<JeecgOrderCustomer> jeecgOrderCustomerList, List<JeecgOrderTicket> jeecgOrderTicketList) {
        this.jeecgOrderMainMapper.insert(jeecgOrderMain);
        if (jeecgOrderCustomerList != null) {
            for (JeecgOrderCustomer jeecgOrderCustomer : jeecgOrderCustomerList) {
                jeecgOrderCustomer.setOrderId(jeecgOrderMain.getId());
                this.jeecgOrderCustomerMapper.insert(jeecgOrderCustomer);
            }
        }
        if (jeecgOrderTicketList != null) {
            for (JeecgOrderTicket jeecgOrderTicket : jeecgOrderTicketList) {
                jeecgOrderTicket.setOrderId(jeecgOrderMain.getId());
                this.jeecgOrderTicketMapper.insert(jeecgOrderTicket);
            }
        }
    }

    @Override
    @Transactional
    public void updateMain(JeecgOrderMain jeecgOrderMain, List<JeecgOrderCustomer> jeecgOrderCustomerList, List<JeecgOrderTicket> jeecgOrderTicketList) {
        this.jeecgOrderMainMapper.updateById(jeecgOrderMain);
        this.jeecgOrderTicketMapper.deleteTicketsByMainId(jeecgOrderMain.getId());
        this.jeecgOrderCustomerMapper.deleteCustomersByMainId(jeecgOrderMain.getId());
        if (jeecgOrderCustomerList != null) {
            for (JeecgOrderCustomer jeecgOrderCustomer : jeecgOrderCustomerList) {
                jeecgOrderCustomer.setOrderId(jeecgOrderMain.getId());
                this.jeecgOrderCustomerMapper.insert(jeecgOrderCustomer);
            }
        }
        if (jeecgOrderTicketList != null) {
            for (JeecgOrderTicket jeecgOrderTicket : jeecgOrderTicketList) {
                jeecgOrderTicket.setOrderId(jeecgOrderMain.getId());
                this.jeecgOrderTicketMapper.insert(jeecgOrderTicket);
            }
        }
    }

    @Override
    @Transactional
    public void delMain(String id) {
        this.jeecgOrderMainMapper.deleteById((Serializable)((Object)id));
        this.jeecgOrderTicketMapper.deleteTicketsByMainId(id);
        this.jeecgOrderCustomerMapper.deleteCustomersByMainId(id);
    }

    @Override
    @Transactional
    public void delBatchMain(Collection<? extends Serializable> idList) {
        for (Serializable serializable : idList) {
            this.jeecgOrderMainMapper.deleteById(serializable);
            this.jeecgOrderTicketMapper.deleteTicketsByMainId(serializable.toString());
            this.jeecgOrderCustomerMapper.deleteCustomersByMainId(serializable.toString());
        }
    }
}

