/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfDiv;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Div
extends AbstractTagProcessor {
    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        List<Chunk> sanitizedChunks = HTMLUtils.sanitize(content, false);
        NoNewLineParagraph noNewLineParagraph = new NoNewLineParagraph();
        ArrayList<Element> l = new ArrayList<Element>(1);
        for (Chunk sanitized : sanitizedChunks) {
            Font f = this.getCssAppliers().getChunkCssAplier().applyFontStyles(tag);
            sanitized.setFont(f);
            noNewLineParagraph.add((Element)sanitized);
        }
        if (noNewLineParagraph.size() > 0) {
            try {
                l.add(this.getCssAppliers().apply((Element)noNewLineParagraph, tag, this.getHtmlPipelineContext(ctx)));
            }
            catch (NoCustomContextException e) {
                throw new RuntimeWorkerException(e);
            }
        }
        return l;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        try {
            Paragraph p = null;
            PdfDiv div = (PdfDiv)this.getCssAppliers().apply((Element)new PdfDiv(), tag, this.getHtmlPipelineContext(ctx));
            for (Element e : currentContent) {
                if (e instanceof Paragraph || e instanceof PdfDiv) {
                    if (p != null) {
                        if (p.trim()) {
                            div.addElement(p);
                        }
                        p = null;
                    }
                    div.addElement(e);
                    continue;
                }
                if (p == null) {
                    p = new Paragraph();
                    p.setMultipliedLeading(1.2f);
                }
                p.add(e);
            }
            if (p != null && p.trim()) {
                div.addElement(p);
            }
            ArrayList<Element> l = new ArrayList<Element>(1);
            l.add((Element)div);
            return l;
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

