/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssApplier;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.WidthCalculator;
import com.itextpdf.tool.xml.html.pdfelement.HtmlCell;
import com.itextpdf.tool.xml.html.table.CellSpacingEvent;
import com.itextpdf.tool.xml.html.table.Table;
import com.itextpdf.tool.xml.html.table.TableStyleValues;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlCellCssApplier
implements CssApplier<HtmlCell> {
    private final CssUtils utils = CssUtils.getInstance();
    private final HtmlPipelineContext configuration;

    public HtmlCellCssApplier(HtmlPipelineContext htmlPipelineContext) {
        this.configuration = htmlPipelineContext;
    }

    @Override
    public HtmlCell apply(HtmlCell cell, Tag t) {
        Map<String, String> css;
        String emptyCells;
        TableStyleValues values = new TableStyleValues();
        Tag table = t.getParent();
        while (!table.getTag().equals("table")) {
            table = table.getParent();
        }
        String border = table.getAttributes().get("border");
        if (border != null && !border.equals("0")) {
            values.setBorderColor(BaseColor.BLACK);
            values.setBorderWidth(0.75f);
        }
        if (null != (emptyCells = (css = t.getCSS()).get("empty-cells")) && "hide".equalsIgnoreCase(emptyCells) && cell.getCompositeElements() == null) {
            cell.setBorder(0);
        } else {
            String rowspan;
            String colspan;
            cell.setVerticalAlignment(5);
            if (t.getAttributes().get("width") != null || css.get("width") != null) {
                cell.setFixedWidth(new WidthCalculator().getWidth(t, this.configuration.getRootTags(), this.configuration.getPageSize().getWidth()));
            }
            if (null != (colspan = t.getAttributes().get("colspan"))) {
                cell.setColspan(Integer.parseInt(colspan));
            }
            if (null != (rowspan = t.getAttributes().get("rowspan"))) {
                cell.setRowspan(Integer.parseInt(rowspan));
            }
            for (Map.Entry<String, String> entry : css.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                cell.setUseBorderPadding(true);
                if (key.equalsIgnoreCase("height")) {
                    cell.setMinimumHeight(this.utils.parsePxInCmMmPcToPt(value));
                    continue;
                }
                if (key.equalsIgnoreCase("background-color")) {
                    values.setBackground(HtmlUtilities.decodeColor((String)value));
                    continue;
                }
                if (key.equalsIgnoreCase("vertical-align")) {
                    if (value.equalsIgnoreCase("top")) {
                        cell.setVerticalAlignment(4);
                        cell.setPaddingTop(cell.getPaddingTop() + 6.0f);
                        continue;
                    }
                    if (!value.equalsIgnoreCase("bottom")) continue;
                    cell.setVerticalAlignment(6);
                    cell.setPaddingBottom(cell.getPaddingBottom() + 6.0f);
                    continue;
                }
                if (key.contains("border")) {
                    if (key.contains("top")) {
                        this.setTopOfBorder(cell, key, value, values);
                        continue;
                    }
                    if (key.contains("bottom")) {
                        this.setBottomOfBorder(cell, key, value, values);
                        continue;
                    }
                    if (key.contains("left")) {
                        this.setLeftOfBorder(cell, key, value, values);
                        continue;
                    }
                    if (!key.contains("right")) continue;
                    this.setRightOfBorder(cell, key, value, values);
                    continue;
                }
                if (key.contains("cellpadding") || key.contains("padding")) {
                    if (key.contains("top")) {
                        cell.setPaddingTop(cell.getPaddingTop() + this.utils.parsePxInCmMmPcToPt(value));
                        continue;
                    }
                    if (key.contains("bottom")) {
                        cell.setPaddingBottom(cell.getPaddingBottom() + this.utils.parsePxInCmMmPcToPt(value));
                        continue;
                    }
                    if (key.contains("left")) {
                        cell.setPaddingLeft(cell.getPaddingLeft() + this.utils.parsePxInCmMmPcToPt(value));
                        continue;
                    }
                    if (!key.contains("right")) continue;
                    cell.setPaddingRight(cell.getPaddingRight() + this.utils.parsePxInCmMmPcToPt(value));
                    continue;
                }
                if (!key.contains("text-align")) continue;
                if (value.equalsIgnoreCase("left")) {
                    cell.setHorizontalAlignment(0);
                    continue;
                }
                if (value.equalsIgnoreCase("center")) {
                    cell.setHorizontalAlignment(1);
                    continue;
                }
                if (!value.equalsIgnoreCase("right")) continue;
                cell.setHorizontalAlignment(2);
            }
            float horSpacing = new Table().getBorderOrCellSpacing(true, table.getCSS(), table.getAttributes());
            float verSpacing = new Table().getBorderOrCellSpacing(false, table.getCSS(), table.getAttributes());
            values.setHorBorderSpacing(horSpacing);
            values.setVerBorderSpacing(verSpacing);
            cell.setPaddingLeft(cell.getPaddingLeft() + horSpacing + values.getBorderWidthLeft());
            cell.setPaddingRight(cell.getPaddingRight() + values.getBorderWidthRight());
            cell.setPaddingTop(cell.getPaddingTop() + verSpacing + values.getBorderWidthTop());
            cell.setPaddingBottom(cell.getPaddingBottom() + values.getBorderWidthBottom() + 1.0f);
        }
        cell.setBorder(0);
        cell.setCellEvent(new CellSpacingEvent(values));
        cell.setCellValues(values);
        return cell;
    }

    private void setTopOfBorder(HtmlCell cell, String key, String value, TableStyleValues values) {
        if (key.contains("width")) {
            values.setBorderWidthTop(this.utils.parsePxInCmMmPcToPt(value));
        }
        if (key.contains("color")) {
            values.setBorderColorTop(HtmlUtilities.decodeColor((String)value));
        } else if (values.getBorderColorTop() == null) {
            values.setBorderColorTop(BaseColor.BLACK);
        }
        if (key.contains("style") && values.getBorderWidthTop() == 0.0f) {
            values.setBorderWidthTop(2.25f);
        }
    }

    private void setBottomOfBorder(HtmlCell cell, String key, String value, TableStyleValues values) {
        if (key.contains("width")) {
            values.setBorderWidthBottom(this.utils.parsePxInCmMmPcToPt(value));
        }
        if (key.contains("color")) {
            values.setBorderColorBottom(HtmlUtilities.decodeColor((String)value));
        } else if (values.getBorderColorBottom() == null) {
            values.setBorderColorBottom(BaseColor.BLACK);
        }
        if (key.contains("style") && values.getBorderWidthBottom() == 0.0f) {
            values.setBorderWidthBottom(2.25f);
        }
    }

    private void setLeftOfBorder(HtmlCell cell, String key, String value, TableStyleValues values) {
        if (key.contains("width")) {
            values.setBorderWidthLeft(this.utils.parsePxInCmMmPcToPt(value));
        }
        if (key.contains("color")) {
            values.setBorderColorLeft(HtmlUtilities.decodeColor((String)value));
        } else if (values.getBorderColorLeft() == null) {
            values.setBorderColorLeft(BaseColor.BLACK);
        }
        if (key.contains("style") && values.getBorderWidthLeft() == 0.0f) {
            values.setBorderWidthLeft(2.25f);
        }
    }

    private void setRightOfBorder(HtmlCell cell, String key, String value, TableStyleValues values) {
        if (key.contains("width")) {
            values.setBorderWidthRight(this.utils.parsePxInCmMmPcToPt(value));
        }
        if (key.contains("color")) {
            values.setBorderColorRight(HtmlUtilities.decodeColor((String)value));
        } else if (values.getBorderColorRight() == null) {
            values.setBorderColorRight(BaseColor.BLACK);
        }
        if (key.contains("style") && values.getBorderWidthRight() == 0.0f) {
            values.setBorderWidthRight(2.25f);
        }
    }
}

