/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.svg.renderers.IMarkerCapable;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.PolylineSvgNodeRenderer;
import com.itextpdf.svg.utils.DrawUtils;

public class PolygonSvgNodeRenderer
extends PolylineSvgNodeRenderer
implements IMarkerCapable {
    @Override
    protected void setPoints(String pointsAttribute) {
        super.setPoints(pointsAttribute);
        this.connectPoints();
    }

    private void connectPoints() {
        if (this.points.size() < 2) {
            return;
        }
        Point start = (Point)this.points.get(0);
        Point end = (Point)this.points.get(this.points.size() - 1);
        if (Double.compare(start.getX(), end.getX()) != 0 || Double.compare(start.getY(), end.getY()) != 0) {
            this.points.add(new Point(start.getX(), start.getY()));
        }
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        PolygonSvgNodeRenderer copy = new PolygonSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    void doStrokeOrFill(String fillRuleRawValue, PdfCanvas currentCanvas) {
        DrawUtils.doStrokeOrFillForClosedFigure(fillRuleRawValue, currentCanvas, this.doStroke);
    }
}

