/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.geom.Vector;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.svg.MarkerVertexType;
import com.itextpdf.svg.renderers.IMarkerCapable;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.MarkerSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCoordinateUtils;
import java.util.Map;

public class LineSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements IMarkerCapable {
    private float x1 = 0.0f;
    private float y1 = 0.0f;
    private float x2 = 0.0f;
    private float y2 = 0.0f;

    @Override
    public void doDraw(SvgDrawContext context) {
        PdfCanvas canvas = context.getCurrentCanvas();
        canvas.writeLiteral("% line\n");
        if (this.setParameters(context)) {
            float[] points = new float[]{this.x1, this.y1, this.x2, this.y2};
            AffineTransform transform = this.applyNonScalingStrokeTransform(context);
            if (transform != null) {
                transform.transform(points, 0, points, 0, points.length / 2);
            }
            int i = 0;
            canvas.moveTo((double)points[i++], (double)points[i++]).lineTo((double)points[i++], (double)points[i]);
        }
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        if (this.setParameters(context)) {
            float x = Math.min(this.x1, this.x2);
            float y = Math.min(this.y1, this.y2);
            float width = Math.abs(this.x1 - this.x2);
            float height = Math.abs(this.y1 - this.y2);
            return new Rectangle(x, y, width, height);
        }
        return null;
    }

    @Override
    protected boolean canElementFill() {
        return false;
    }

    float getAttribute(Map<String, String> attributes, String key) {
        String value = attributes.get(key);
        if (value != null && !value.isEmpty()) {
            return CssDimensionParsingUtils.parseAbsoluteLength((String)attributes.get(key));
        }
        return 0.0f;
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        LineSvgNodeRenderer copy = new LineSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    public void drawMarker(SvgDrawContext context, MarkerVertexType markerVertexType) {
        String moveX = null;
        String moveY = null;
        if (MarkerVertexType.MARKER_START.equals((Object)markerVertexType)) {
            moveX = (String)this.attributesAndStyles.get("x1");
            moveY = (String)this.attributesAndStyles.get("y1");
        } else if (MarkerVertexType.MARKER_END.equals((Object)markerVertexType)) {
            moveX = (String)this.attributesAndStyles.get("x2");
            moveY = (String)this.attributesAndStyles.get("y2");
        }
        if (moveX != null && moveY != null) {
            MarkerSvgNodeRenderer.drawMarker(context, moveX, moveY, markerVertexType, this);
        }
    }

    @Override
    public double getAutoOrientAngle(MarkerSvgNodeRenderer marker, boolean reverse) {
        Vector v = new Vector(this.x2 - this.x1, this.y2 - this.y1, 0.0f);
        Vector xAxis = new Vector(1.0f, 0.0f, 0.0f);
        double rotAngle = SvgCoordinateUtils.calculateAngleBetweenTwoVectors(xAxis, v);
        return v.get(1) >= 0.0f && !reverse ? rotAngle : rotAngle * -1.0;
    }

    private boolean setParameters(SvgDrawContext context) {
        if (this.attributesAndStyles.size() > 0) {
            if (this.attributesAndStyles.containsKey("x1")) {
                this.x1 = this.parseHorizontalLength((String)this.attributesAndStyles.get("x1"), context);
            }
            if (this.attributesAndStyles.containsKey("y1")) {
                this.y1 = this.parseVerticalLength((String)this.attributesAndStyles.get("y1"), context);
            }
            if (this.attributesAndStyles.containsKey("x2")) {
                this.x2 = this.parseHorizontalLength((String)this.attributesAndStyles.get("x2"), context);
            }
            if (this.attributesAndStyles.containsKey("y2")) {
                this.y2 = this.parseVerticalLength((String)this.attributesAndStyles.get("y2"), context);
            }
            return true;
        }
        return false;
    }
}

