/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.svg.element.SvgImage;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import com.itextpdf.svg.xobject.SvgImageXObject;

public class SvgImageRenderer
extends ImageRenderer {
    public SvgImageRenderer(SvgImage image) {
        super((Image)image);
    }

    public LayoutResult layout(LayoutContext layoutContext) {
        SvgImage svgImage = (SvgImage)this.modelElement;
        Rectangle layoutBox = layoutContext.getArea().getBBox();
        if (svgImage.getSvgImageXObject().isRelativeSized()) {
            this.calculateRelativeSizedSvgSize(svgImage, layoutBox);
        } else if (svgImage.getSvgImageXObject().isCreatedByObject() && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
            NullableArea retrievedArea = new NullableArea(this.retrieveWidth(layoutBox.getWidth()), this.retrieveHeight());
            PdfArray bbox = svgImage.getSvgImageXObject().getBBox();
            if (retrievedArea.width != null && retrievedArea.height != null) {
                bbox.set(2, (PdfObject)new PdfNumber((double)retrievedArea.width.floatValue()));
                bbox.set(3, (PdfObject)new PdfNumber((double)retrievedArea.height.floatValue()));
                this.imageWidth = retrievedArea.width.floatValue();
                this.imageHeight = retrievedArea.height.floatValue();
            } else if (retrievedArea.width != null) {
                Area bboxArea = new Area(((PdfNumber)bbox.get(2)).floatValue(), ((PdfNumber)bbox.get(3)).floatValue());
                double verticalScaling = (double)retrievedArea.width.floatValue() / (double)bboxArea.width;
                bbox.set(2, (PdfObject)new PdfNumber((double)retrievedArea.width.floatValue()));
                bbox.set(3, (PdfObject)new PdfNumber((double)bboxArea.height * verticalScaling));
                this.imageWidth = retrievedArea.width.floatValue();
                this.imageHeight *= (float)verticalScaling;
            } else if (retrievedArea.height != null) {
                Area bboxArea = new Area(((PdfNumber)bbox.get(2)).floatValue(), ((PdfNumber)bbox.get(3)).floatValue());
                double horizontalScaling = (double)retrievedArea.height.floatValue() / (double)bboxArea.height;
                bbox.set(2, (PdfObject)new PdfNumber((double)bboxArea.width * horizontalScaling));
                bbox.set(3, (PdfObject)new PdfNumber((double)retrievedArea.height.floatValue()));
                this.imageWidth *= (float)horizontalScaling;
                this.imageHeight = retrievedArea.height.floatValue();
            }
        }
        return super.layout(layoutContext);
    }

    public void draw(DrawContext drawContext) {
        ((SvgImage)this.modelElement).getSvgImageXObject().generate(drawContext.getDocument());
        super.draw(drawContext);
    }

    private void calculateRelativeSizedSvgSize(SvgImage svgImage, Rectangle layoutBox) {
        SvgImageXObject svgImageXObject = svgImage.getSvgImageXObject();
        ISvgNodeRenderer svgRootRenderer = svgImageXObject.getResult().getRootRenderer();
        Float aspectRatio = null;
        float[] viewBoxValues = SvgCssUtils.parseViewBox(svgRootRenderer);
        if (viewBoxValues != null && viewBoxValues.length == 4) {
            aspectRatio = Float.valueOf(viewBoxValues[2] / viewBoxValues[3]);
        }
        NullableArea retrievedArea = new NullableArea(this.retrieveWidth(layoutBox.getWidth()), this.retrieveHeight());
        boolean preserveAspectRatioNone = "none".equals(svgRootRenderer.getAttribute("preserveAspectRatio"));
        Area area = new Area();
        float f = retrievedArea.width == null ? (aspectRatio == null ? 225.0f : layoutBox.getWidth()) : (area.width = retrievedArea.width.floatValue());
        area.height = retrievedArea.height == null ? (aspectRatio == null ? 112.5f : layoutBox.getHeight()) : retrievedArea.height.floatValue();
        UnitValue elementWidth = svgImageXObject.getElementWidth();
        UnitValue elementHeight = svgImageXObject.getElementHeight();
        Area finalArea = new Area();
        if (preserveAspectRatioNone && svgImageXObject.isCreatedByImg()) {
            finalArea.width = retrievedArea.width == null ? 225.0f : retrievedArea.width.floatValue();
            finalArea.height = retrievedArea.height == null ? 112.5f : retrievedArea.height.floatValue();
        } else {
            finalArea = this.initMissingMetricsAndApplyAspectRatio(aspectRatio, retrievedArea, area, elementWidth, elementHeight);
        }
        if (svgImageXObject.isCreatedByImg() && viewBoxValues == null) {
            if (this.getProperty(77) == null) {
                this.setProperty(77, UnitValue.createPointValue((float)finalArea.width));
            }
            if (this.retrieveHeight() == null) {
                this.setProperty(27, UnitValue.createPointValue((float)finalArea.height));
            }
            svgImageXObject.updateBBox(finalArea.width, finalArea.height);
        } else {
            svgRootRenderer.setAttribute("width", null);
            svgRootRenderer.setAttribute("height", null);
            svgImageXObject.updateBBox(finalArea.width, finalArea.height);
        }
        this.imageWidth = svgImage.getImageWidth();
        this.imageHeight = svgImage.getImageHeight();
    }

    private Area initMissingMetricsAndApplyAspectRatio(Float aspectRatio, NullableArea retrievedArea, Area area, UnitValue xObjectWidth, UnitValue xObjectHeight) {
        Area finalArea = new Area();
        if (!SvgImageRenderer.tryToApplyAspectRatio(retrievedArea, area, finalArea, aspectRatio)) {
            boolean isAspectRatioApplied;
            if (xObjectWidth != null && xObjectWidth.isPointValue() && retrievedArea.width == null) {
                area.width = xObjectWidth.getValue();
                retrievedArea.width = Float.valueOf(area.width);
                this.setProperty(77, UnitValue.createPointValue((float)area.width));
            }
            if (xObjectHeight != null && xObjectHeight.isPointValue() && retrievedArea.height == null) {
                area.height = xObjectHeight.getValue();
                retrievedArea.height = Float.valueOf(area.height);
                this.setProperty(27, UnitValue.createPointValue((float)area.height));
            }
            if (!(isAspectRatioApplied = SvgImageRenderer.tryToApplyAspectRatio(retrievedArea, area, area, aspectRatio)) && aspectRatio != null && retrievedArea.height == null) {
                area.height = area.width / aspectRatio.floatValue();
            }
            finalArea.width = area.width;
            finalArea.height = area.height;
        }
        return finalArea;
    }

    private static boolean tryToApplyAspectRatio(NullableArea retrievedArea, Area inputArea, Area resultArea, Float aspectRatio) {
        if (aspectRatio == null) {
            return false;
        }
        if (retrievedArea.width == null && retrievedArea.height != null) {
            resultArea.height = inputArea.height;
            resultArea.width = inputArea.height * aspectRatio.floatValue();
            return true;
        }
        if (retrievedArea.width != null && retrievedArea.height == null) {
            resultArea.width = inputArea.width;
            resultArea.height = inputArea.width / aspectRatio.floatValue();
            return true;
        }
        return false;
    }

    private static class Area {
        public float width;
        public float height;

        public Area() {
            this.width = 0.0f;
            this.height = 0.0f;
        }

        public Area(float width, float height) {
            this.width = width;
            this.height = height;
        }
    }

    private static class NullableArea {
        public Float width;
        public Float height;

        public NullableArea(Float width, Float height) {
            this.width = width;
            this.height = height;
        }
    }
}

