/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.utils;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceGray;
import com.itextpdf.layout.properties.Underline;
import java.util.ArrayList;
import java.util.List;

public class SvgTextProperties {
    private Color fillColor = DeviceGray.BLACK;
    private Color strokeColor = DeviceGray.BLACK;
    private float fillOpacity = 1.0f;
    private float strokeOpacity = 1.0f;
    private float[] dashArray = null;
    private float dashPhase = 0.0f;
    private float lineWidth = 1.0f;
    private List<Underline> textDecoration = new ArrayList<Underline>();

    public SvgTextProperties() {
    }

    public SvgTextProperties(SvgTextProperties textProperties) {
        this.fillColor = textProperties.getFillColor();
        this.strokeColor = textProperties.getStrokeColor();
        this.fillOpacity = textProperties.getFillOpacity();
        this.strokeOpacity = textProperties.getStrokeOpacity();
        this.dashArray = textProperties.getDashArray();
        this.dashPhase = textProperties.getDashPhase();
        this.lineWidth = textProperties.getLineWidth();
        this.textDecoration = textProperties.getTextDecoration();
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public SvgTextProperties setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
        return this;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public SvgTextProperties setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        return this;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public SvgTextProperties setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public float getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public SvgTextProperties setStrokeOpacity(float strokeOpacity) {
        this.strokeOpacity = strokeOpacity;
        return this;
    }

    public float getFillOpacity() {
        return this.fillOpacity;
    }

    public SvgTextProperties setFillOpacity(float fillOpacity) {
        this.fillOpacity = fillOpacity;
        return this;
    }

    public List<Underline> getTextDecoration() {
        return this.textDecoration;
    }

    public SvgTextProperties setTextDecoration(List<Underline> underlineList) {
        this.textDecoration = underlineList;
        return this;
    }

    public float[] getDashArray() {
        return this.dashArray;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public SvgTextProperties setDashPattern(float[] dashArray, float dashPhase) {
        this.dashArray = dashArray;
        this.dashPhase = dashPhase;
        return this;
    }
}

