/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import com.itextpdf.svg.utils.SvgCoordinateUtils;
import java.util.Arrays;

public class MoveTo
extends AbstractPathShape {
    private String[] coordinates;

    public MoveTo() {
        this(false);
    }

    public MoveTo(boolean relative) {
        this.relative = relative;
    }

    @Override
    public void draw(PdfCanvas canvas) {
        float x = CssUtils.parseAbsoluteLength((String)this.coordinates[0]);
        float y = CssUtils.parseAbsoluteLength((String)this.coordinates[1]);
        canvas.moveTo((double)x, (double)y);
    }

    @Override
    public void setCoordinates(String[] coordinates, Point startPoint) {
        if (coordinates.length == 0 || coordinates.length % 2 != 0) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"(x y)+ parameters are expected for moveTo operator. Got: {0}", (Object[])new Object[]{Arrays.toString(coordinates)}));
        }
        if (coordinates.length > 2) {
            throw new UnsupportedOperationException();
        }
        this.coordinates = new String[]{coordinates[0], coordinates[1]};
        if (this.isRelative()) {
            this.coordinates = SvgCoordinateUtils.makeRelativeOperatorCoordinatesAbsolute(coordinates, new double[]{startPoint.x, startPoint.y});
        }
    }

    @Override
    public Point getEndingPoint() {
        return this.createPoint(this.coordinates[0], this.coordinates[1]);
    }
}

