/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import com.itextpdf.svg.utils.SvgCoordinateUtils;
import java.util.Arrays;

public class LineTo
extends AbstractPathShape {
    protected String[][] coordinates;

    public LineTo() {
        this(false);
    }

    public LineTo(boolean relative) {
        this.relative = relative;
    }

    @Override
    public void draw(PdfCanvas canvas) {
        for (int i = 0; i < this.coordinates.length; ++i) {
            float x = CssUtils.parseAbsoluteLength((String)this.coordinates[i][0]);
            float y = CssUtils.parseAbsoluteLength((String)this.coordinates[i][1]);
            canvas.lineTo((double)x, (double)y);
        }
    }

    @Override
    public void setCoordinates(String[] coordinates, Point startPoint) {
        if (coordinates.length == 0 || coordinates.length % 2 != 0) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"(x y)+ parameters are expected for lineTo operator. Got: {0}", (Object[])new Object[]{Arrays.toString(coordinates)}));
        }
        this.coordinates = new String[coordinates.length / 2][];
        double[] initialPoint = new double[]{startPoint.getX(), startPoint.getY()};
        for (int i = 0; i < coordinates.length; i += 2) {
            String[] curCoordinates = new String[]{coordinates[i], coordinates[i + 1]};
            if (this.isRelative()) {
                curCoordinates = SvgCoordinateUtils.makeRelativeOperatorCoordinatesAbsolute(curCoordinates, initialPoint);
                initialPoint[0] = CssUtils.parseFloat((String)curCoordinates[0]).floatValue();
                initialPoint[1] = CssUtils.parseFloat((String)curCoordinates[1]).floatValue();
            }
            this.coordinates[i / 2] = curCoordinates;
        }
    }

    @Override
    public Point getEndingPoint() {
        return this.createPoint(this.coordinates[this.coordinates.length - 1][0], this.coordinates[this.coordinates.length - 1][1]);
    }
}

