/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import com.itextpdf.svg.utils.SvgCoordinateUtils;
import java.util.Arrays;

public class CurveTo
extends AbstractPathShape {
    private String[][] coordinates;

    public CurveTo() {
        this(false);
    }

    public CurveTo(boolean relative) {
        this.relative = relative;
    }

    @Override
    public void draw(PdfCanvas canvas) {
        for (int i = 0; i < this.coordinates.length; ++i) {
            float x1 = CssUtils.parseAbsoluteLength((String)this.coordinates[i][0]);
            float y1 = CssUtils.parseAbsoluteLength((String)this.coordinates[i][1]);
            float x2 = CssUtils.parseAbsoluteLength((String)this.coordinates[i][2]);
            float y2 = CssUtils.parseAbsoluteLength((String)this.coordinates[i][3]);
            float x = CssUtils.parseAbsoluteLength((String)this.coordinates[i][4]);
            float y = CssUtils.parseAbsoluteLength((String)this.coordinates[i][5]);
            canvas.curveTo((double)x1, (double)y1, (double)x2, (double)y2, (double)x, (double)y);
        }
    }

    @Override
    public void setCoordinates(String[] coordinates, Point startPoint) {
        if (coordinates.length == 0 || coordinates.length % 6 != 0) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"(x1 y1 x2 y2 x y)+ parameters are expected for curves. Got: {0}", (Object[])new Object[]{Arrays.toString(coordinates)}));
        }
        this.coordinates = new String[coordinates.length / 6][];
        double[] initialPoint = new double[]{startPoint.getX(), startPoint.getY()};
        for (int i = 0; i < coordinates.length; i += 6) {
            String[] curCoordinates = new String[]{coordinates[i], coordinates[i + 1], coordinates[i + 2], coordinates[i + 3], coordinates[i + 4], coordinates[i + 5]};
            if (this.isRelative()) {
                curCoordinates = SvgCoordinateUtils.makeRelativeOperatorCoordinatesAbsolute(curCoordinates, initialPoint);
                initialPoint[0] = CssUtils.parseFloat((String)curCoordinates[4]).floatValue();
                initialPoint[1] = CssUtils.parseFloat((String)curCoordinates[5]).floatValue();
            }
            this.coordinates[i / 6] = curCoordinates;
        }
    }

    public Point getLastControlPoint() {
        return this.createPoint(this.coordinates[this.coordinates.length - 1][2], this.coordinates[this.coordinates.length - 1][3]);
    }

    @Override
    public Point getEndingPoint() {
        return this.createPoint(this.coordinates[this.coordinates.length - 1][4], this.coordinates[this.coordinates.length - 1][5]);
    }
}

