/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.path.IPathShape;
import com.itextpdf.svg.renderers.path.SvgPathShapeFactory;
import com.itextpdf.svg.renderers.path.impl.ClosePath;
import com.itextpdf.svg.renderers.path.impl.CurveTo;
import com.itextpdf.svg.renderers.path.impl.MoveTo;
import com.itextpdf.svg.renderers.path.impl.SmoothSCurveTo;
import com.itextpdf.svg.utils.SvgCssUtils;
import com.itextpdf.svg.utils.SvgRegexUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    private static final String SEPARATOR = "";
    private static final String SPACE_CHAR = " ";
    private static final Logger LOGGER = LoggerFactory.getLogger(PathSvgNodeRenderer.class);
    private static final int MOVETOARGUMENTNR = 2;
    private static final String INVALID_OPERATOR_REGEX = "(?:(?![mzlhvcsqtae])\\p{L})";
    private static Pattern invalidRegexPattern = Pattern.compile("(?:(?![mzlhvcsqtae])\\p{L})", 2);
    private static final String SPLIT_REGEX = "(?=[\\p{L}])";
    private Point currentPoint = null;
    private ClosePath zOperator = null;

    @Override
    public void doDraw(SvgDrawContext context) {
        PdfCanvas canvas = context.getCurrentCanvas();
        canvas.writeLiteral("% path\n");
        this.currentPoint = new Point(0, 0);
        for (IPathShape item : this.getShapes()) {
            item.draw(canvas);
        }
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        PathSvgNodeRenderer copy = new PathSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    private String[] getShapeCoordinates(IPathShape shape, IPathShape previousShape, String[] pathProperties) {
        if (shape instanceof ClosePath) {
            return null;
        }
        String[] shapeCoordinates = null;
        String[] operatorArgs = Arrays.copyOfRange(pathProperties, 1, pathProperties.length);
        if (shape instanceof SmoothSCurveTo) {
            String[] startingControlPoint = new String[2];
            if (previousShape != null) {
                Point previousEndPoint = previousShape.getEndingPoint();
                if (previousShape instanceof CurveTo) {
                    Point lastControlPoint = ((CurveTo)previousShape).getLastControlPoint();
                    float reflectedX = (float)(2.0 * previousEndPoint.getX() - lastControlPoint.getX());
                    float reflectedY = (float)(2.0 * previousEndPoint.getY() - lastControlPoint.getY());
                    startingControlPoint[0] = SvgCssUtils.convertFloatToString(reflectedX);
                    startingControlPoint[1] = SvgCssUtils.convertFloatToString(reflectedY);
                } else {
                    startingControlPoint[0] = SvgCssUtils.convertDoubleToString(previousEndPoint.getX());
                    startingControlPoint[1] = SvgCssUtils.convertDoubleToString(previousEndPoint.getY());
                }
            } else {
                startingControlPoint[0] = pathProperties[1];
                startingControlPoint[1] = pathProperties[2];
            }
            shapeCoordinates = PathSvgNodeRenderer.concatenate(startingControlPoint, operatorArgs);
        }
        if (shapeCoordinates == null) {
            shapeCoordinates = operatorArgs;
        }
        return shapeCoordinates;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<IPathShape> processPathOperator(String[] pathProperties, IPathShape previousShape) {
        ArrayList<IPathShape> shapes = new ArrayList<IPathShape>();
        if (pathProperties.length == 0 || pathProperties[0].equals(SEPARATOR)) {
            return shapes;
        }
        IPathShape pathShape = SvgPathShapeFactory.createPathShape(pathProperties[0]);
        String[] shapeCoordinates = this.getShapeCoordinates(pathShape, previousShape, pathProperties);
        if (pathShape instanceof ClosePath) {
            if (previousShape == null) throw new SvgProcessingException("The close path operator (Z) may not be used before a move to operation (M)");
            pathShape = this.zOperator;
        } else if (pathShape instanceof MoveTo) {
            this.zOperator = new ClosePath(pathShape.isRelative());
            if (shapeCoordinates != null && shapeCoordinates.length != 2) {
                LOGGER.warn(MessageFormatUtil.format((String)"Path operator {0} has received {1} arguments, but expects between {2} and {3} arguments. \n Resulting SVG will be incorrect.", (Object[])new Object[]{pathProperties[0], shapeCoordinates.length, 2, 2}));
            }
            this.zOperator.setCoordinates(shapeCoordinates, this.currentPoint);
        }
        if (pathShape == null) return shapes;
        if (shapeCoordinates != null) {
            pathShape.setCoordinates(shapeCoordinates, this.currentPoint);
        }
        this.currentPoint = pathShape.getEndingPoint();
        shapes.add(pathShape);
        return shapes;
    }

    private Collection<IPathShape> getShapes() {
        Collection<String> parsedResults = this.parsePropertiesAndStyles();
        ArrayList<IPathShape> shapes = new ArrayList<IPathShape>();
        for (String parsedResult : parsedResults) {
            String[] pathProperties = parsedResult.split(" +");
            IPathShape previousShape = shapes.size() == 0 ? null : (IPathShape)shapes.get(shapes.size() - 1);
            List<IPathShape> operatorShapes = this.processPathOperator(pathProperties, previousShape);
            shapes.addAll(operatorShapes);
        }
        return shapes;
    }

    private static String[] concatenate(String[] first, String[] second) {
        String[] arr = new String[first.length + second.length];
        System.arraycopy(first, 0, arr, 0, first.length);
        System.arraycopy(second, 0, arr, first.length, second.length);
        return arr;
    }

    boolean containsInvalidAttributes(String attributes) {
        return SvgRegexUtils.containsAtLeastOneMatch(invalidRegexPattern, attributes);
    }

    private Collection<String> parsePropertiesAndStyles() {
        String[] coordinates;
        StringBuilder result = new StringBuilder();
        String attributes = (String)this.attributesAndStyles.get("d");
        if (this.containsInvalidAttributes(attributes)) {
            throw new SvgProcessingException("Invalid operators found in path data attribute: {0}").setMessageParams(new Object[]{attributes});
        }
        for (String inst : coordinates = attributes.split(SPLIT_REGEX)) {
            if (inst.equals(SEPARATOR)) continue;
            String instTrim = inst.trim();
            String instruction = instTrim.charAt(0) + SPACE_CHAR;
            String temp = instruction + instTrim.replace(instTrim.charAt(0) + SEPARATOR, SEPARATOR).replace(",", SPACE_CHAR).trim();
            temp = this.separateDecimalPoints(temp);
            result.append(SPACE_CHAR);
            result.append(temp);
        }
        String[] resultArray = result.toString().split(SPLIT_REGEX);
        return new ArrayList<String>(Arrays.asList(resultArray));
    }

    String separateDecimalPoints(String input) {
        StringBuilder res = new StringBuilder();
        boolean decimalPointEncountered = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (decimalPointEncountered && (c == '-' || Character.isWhitespace(c))) {
                decimalPointEncountered = false;
            }
            if (c == '.') {
                if (decimalPointEncountered) {
                    res.append(SPACE_CHAR);
                } else {
                    decimalPointEncountered = true;
                }
            } else if (c == '-') {
                res.append(SPACE_CHAR);
            }
            res.append(c);
        }
        return res.toString();
    }
}

