/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.css.impl.SvgNodeRendererInheritanceResolver;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgMathUtils;

public class UseSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            String normalizedName;
            String elementToReUse = (String)this.attributesAndStyles.get("xlink:href");
            if (elementToReUse == null) {
                elementToReUse = (String)this.attributesAndStyles.get("href");
            }
            if (elementToReUse != null && !elementToReUse.isEmpty() && this.isValidHref(elementToReUse) && !context.isIdUsedByUseTagBefore(normalizedName = this.normalizeName(elementToReUse))) {
                ISvgNodeRenderer template = context.getNamedObject(normalizedName);
                ISvgNodeRenderer namedObject = template.createDeepCopy();
                SvgNodeRendererInheritanceResolver iresolver = new SvgNodeRendererInheritanceResolver();
                iresolver.applyInheritanceToSubTree(this, namedObject);
                if (namedObject != null) {
                    PdfCanvas currentCanvas = context.getCurrentCanvas();
                    float x = 0.0f;
                    float y = 0.0f;
                    if (this.attributesAndStyles.containsKey("x")) {
                        x = CssUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("x")));
                    }
                    if (this.attributesAndStyles.containsKey("y")) {
                        y = CssUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("y")));
                    }
                    if (!SvgMathUtils.compareFloats(x, 0.0f) || !SvgMathUtils.compareFloats(y, 0.0f)) {
                        AffineTransform translation = AffineTransform.getTranslateInstance((double)x, (double)y);
                        currentCanvas.concatMatrix(translation);
                    }
                    namedObject.setParent(this);
                    namedObject.draw(context);
                    namedObject.setParent(null);
                }
            }
        }
    }

    private String normalizeName(String name) {
        return name.replace("#", "").trim();
    }

    private boolean isValidHref(String name) {
        return name.startsWith("#");
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        UseSvgNodeRenderer copy = new UseSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

