/*
    This file is part of the iText (R) project.
    Copyright (c) 1998-2025 Apryse Group NV
    Authors: Apryse Software.

    This program is offered under a commercial and under the AGPL license.
    For commercial licensing, contact us at https://itextpdf.com/sales.  For AGPL licensing, see below.

    AGPL licensing:
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.itextpdf.signatures.validation.lotl;

/**
 * Utility class which stores constants for country specific codes.
 */
public final class LotlCountryCodeConstants {
    public static final String AUSTRIA = "AT";
    public static final String BELGIUM = "BE";
    public static final String BULGARIA = "BG";
    public static final String CYPRUS = "CY";
    public static final String CZECHIA = "CZ";
    public static final String GERMANY = "DE";
    public static final String DENMARK = "DK";
    public static final String ESTONIA = "EE";
    public static final String GREECE = "EL";
    public static final String SPAIN = "ES";
    public static final String FINLAND = "FI";
    public static final String FRANCE = "FR";
    public static final String CROATIA = "HR";
    public static final String HUNGARY = "HU";
    public static final String IRELAND = "IE";
    public static final String ICELAND = "IS";
    public static final String ITALY = "IT";
    public static final String LIECHTENSTEIN = "LI";
    public static final String LITHUANIA = "LT";
    public static final String LUXEMBOURG = "LU";
    public static final String LATVIA = "LV";
    public static final String MALTA = "MT";
    public static final String NETHERLANDS = "NL";
    public static final String NORWAY = "NO";
    public static final String POLAND = "PL";
    public static final String PORTUGAL = "PT";
    public static final String ROMANIA = "RO";
    public static final String SWEDEN = "SE";
    public static final String SLOVENIA = "SI";
    public static final String SLOVAKIA = "SK";
    public static final String UNITED_KINGDOM = "UK";

    private LotlCountryCodeConstants() {
        // Private constructor to prevent class initialization.
    }
}
