/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl.criteria;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.validation.lotl.criteria.Criteria;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class PolicySetCriteria
implements Criteria {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final String POLICY_SET_EXTENSION_ID = "2.5.29.32";
    private final List<String> requiredPolicyIdentifiers = new ArrayList<String>();

    public void addRequiredPolicyId(String requiredPolicyId) {
        this.requiredPolicyIdentifiers.add(requiredPolicyId);
    }

    public List<String> getRequiredPolicyIds() {
        return new ArrayList<String>(this.requiredPolicyIdentifiers);
    }

    @Override
    public boolean checkCriteria(X509Certificate certificate) {
        byte[] policyExtension = CertificateUtil.getExtensionValueByOid(certificate, POLICY_SET_EXTENSION_ID);
        if (policyExtension == null) {
            return false;
        }
        try {
            List policyIds = FACTORY.getPoliciesIds(policyExtension);
            for (String requiredPolicyIdentifier : this.requiredPolicyIdentifiers) {
                if (policyIds.contains(requiredPolicyIdentifier)) continue;
                return false;
            }
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }
}

