/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.signatures.validation.lotl.AdditionalServiceInformationExtension;
import com.itextpdf.signatures.validation.lotl.QualifierExtension;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ServiceChronologicalInfo {
    static final String GRANTED = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/granted";
    static final String GRANTED_NATIONALLY = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/recognisedatnationallevel";
    static final String ACCREDITED = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/accredited";
    static final String SET_BY_NATIONAL_LAW = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/setbynationallaw";
    static final String UNDER_SUPERVISION = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/undersupervision";
    static final String SUPERVISION_IN_CESSATION = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/supervisionincessation";
    private static final Set<String> VALID_STATUSES = new HashSet<String>();
    private final List<AdditionalServiceInformationExtension> serviceExtensions = new ArrayList<AdditionalServiceInformationExtension>();
    private final List<QualifierExtension> qualifierExtensions = new ArrayList<QualifierExtension>();
    private final DateTimeFormatter statusStartDateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private String serviceStatus;
    private LocalDateTime serviceStatusStartingTime;

    ServiceChronologicalInfo() {
    }

    ServiceChronologicalInfo(String serviceStatus, LocalDateTime serviceStatusStartingTime) {
        this.serviceStatus = serviceStatus;
        this.serviceStatusStartingTime = serviceStatusStartingTime;
    }

    public String getServiceStatus() {
        return this.serviceStatus;
    }

    public LocalDateTime getServiceStatusStartingTime() {
        return this.serviceStatusStartingTime;
    }

    public List<AdditionalServiceInformationExtension> getServiceExtensions() {
        return this.serviceExtensions;
    }

    public List<QualifierExtension> getQualifierExtensions() {
        return this.qualifierExtensions;
    }

    static boolean isStatusValid(String status) {
        return VALID_STATUSES.contains(status);
    }

    void setServiceStatus(String serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    void setServiceStatusStartingTime(String timeString) {
        this.serviceStatusStartingTime = this.statusStartDateFormat.parse((CharSequence)timeString, LocalDateTime::from);
    }

    void setServiceStatusStartingTime(LocalDateTime serviceStatusStartingTime) {
        this.serviceStatusStartingTime = serviceStatusStartingTime;
    }

    void addServiceExtension(AdditionalServiceInformationExtension extension) {
        this.serviceExtensions.add(extension);
    }

    void addQualifierExtension(QualifierExtension qualifierExtension) {
        this.qualifierExtensions.add(qualifierExtension);
    }

    static {
        VALID_STATUSES.add(GRANTED);
        VALID_STATUSES.add(GRANTED_NATIONALLY);
        VALID_STATUSES.add(ACCREDITED);
        VALID_STATUSES.add(SET_BY_NATIONAL_LAW);
        VALID_STATUSES.add(UNDER_SUPERVISION);
        VALID_STATUSES.add(SUPERVISION_IN_CESSATION);
    }
}

