/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.signatures.validation.EuropeanTrustedListConfigurationFactory;
import com.itextpdf.signatures.validation.SafeCalling;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;

public class EuropeanResourceFetcher {
    public Result getEUJournalCertificates() {
        Result result = new Result();
        EuropeanTrustedListConfigurationFactory factory = EuropeanTrustedListConfigurationFactory.getFactory().get();
        result.setCurrentlySupportedPublication(factory.getCurrentlySupportedPublication());
        SafeCalling.onExceptionLog(() -> result.setCertificates(factory.getCertificates()), result.getLocalReport(), e -> new ReportItem("Lotl validation.", "One of EU Journal trusted certificates in not parsable. It will be ignored.", (Exception)e, ReportItem.ReportItemStatus.INFO));
        return result;
    }

    public static class Result {
        private final ValidationReport localReport = new ValidationReport();
        private List<Certificate> certificates = new ArrayList<Certificate>();
        private String currentlySupportedPublication;

        public ValidationReport getLocalReport() {
            return this.localReport;
        }

        public List<Certificate> getCertificates() {
            return this.certificates;
        }

        public String getCurrentlySupportedPublication() {
            return this.currentlySupportedPublication;
        }

        public void setCertificates(List<Certificate> certificates) {
            this.certificates = certificates;
        }

        public void setCurrentlySupportedPublication(String currentlySuppostedPublication) {
            this.currentlySupportedPublication = currentlySuppostedPublication;
        }
    }
}

