/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.signatures.validation.lotl.xml.IDefaultXmlHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class XmlPivotsHandler
implements IDefaultXmlHandler {
    private final List<String> pivots = new ArrayList<String>();
    private boolean schemeInformationContext = false;
    private StringBuilder uriLink;

    @Override
    public void startElement(String uri, String localName, String qName, HashMap<String, String> attributes) {
        if ("SchemeInformationURI".equals(localName)) {
            this.schemeInformationContext = true;
        } else if ("URI".equals(localName)) {
            this.uriLink = new StringBuilder();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("SchemeInformationURI".equals(localName)) {
            this.schemeInformationContext = false;
        } else if ("URI".equals(localName) && XmlPivotsHandler.isPivot(this.uriLink.toString())) {
            this.pivots.add(this.uriLink.toString());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.schemeInformationContext) {
            this.uriLink.append(ch, start, length);
        }
    }

    public List<String> getPivots() {
        return new ArrayList<String>(this.pivots);
    }

    private static boolean isPivot(String uriLink) {
        return uriLink.contains("eu-lotl-pivot");
    }
}

