/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TrustedCertificatesStore {
    private final Map<String, Set<Certificate>> generallyTrustedCertificates = new HashMap<String, Set<Certificate>>();
    private final Map<String, Set<Certificate>> ocspTrustedCertificates = new HashMap<String, Set<Certificate>>();
    private final Map<String, Set<Certificate>> timestampTrustedCertificates = new HashMap<String, Set<Certificate>>();
    private final Map<String, Set<Certificate>> crlTrustedCertificates = new HashMap<String, Set<Certificate>>();
    private final Map<String, Set<Certificate>> caTrustedCertificates = new HashMap<String, Set<Certificate>>();

    public void addGenerallyTrustedCertificates(Collection<Certificate> certificates) {
        for (Certificate certificate : certificates) {
            TrustedCertificatesStore.addCertificateToMap(certificate, this.generallyTrustedCertificates);
        }
    }

    public void addOcspTrustedCertificates(Collection<Certificate> certificates) {
        for (Certificate certificate : certificates) {
            TrustedCertificatesStore.addCertificateToMap(certificate, this.ocspTrustedCertificates);
        }
    }

    public void addCrlTrustedCertificates(Collection<Certificate> certificates) {
        for (Certificate certificate : certificates) {
            TrustedCertificatesStore.addCertificateToMap(certificate, this.crlTrustedCertificates);
        }
    }

    public void addTimestampTrustedCertificates(Collection<Certificate> certificates) {
        for (Certificate certificate : certificates) {
            TrustedCertificatesStore.addCertificateToMap(certificate, this.timestampTrustedCertificates);
        }
    }

    public void addCATrustedCertificates(Collection<Certificate> certificates) {
        for (Certificate certificate : certificates) {
            TrustedCertificatesStore.addCertificateToMap(certificate, this.caTrustedCertificates);
        }
    }

    public boolean isCertificateGenerallyTrusted(Certificate certificate) {
        return TrustedCertificatesStore.mapContainsCertificate(certificate, this.generallyTrustedCertificates);
    }

    public boolean isCertificateTrustedForOcsp(Certificate certificate) {
        return TrustedCertificatesStore.mapContainsCertificate(certificate, this.ocspTrustedCertificates);
    }

    public boolean isCertificateTrustedForCrl(Certificate certificate) {
        return TrustedCertificatesStore.mapContainsCertificate(certificate, this.crlTrustedCertificates);
    }

    public boolean isCertificateTrustedForTimestamp(Certificate certificate) {
        return TrustedCertificatesStore.mapContainsCertificate(certificate, this.timestampTrustedCertificates);
    }

    public boolean isCertificateTrustedForCA(Certificate certificate) {
        return TrustedCertificatesStore.mapContainsCertificate(certificate, this.caTrustedCertificates);
    }

    public Set<Certificate> getGenerallyTrustedCertificates(String certificateName) {
        return this.generallyTrustedCertificates.getOrDefault(certificateName, Collections.emptySet());
    }

    public Set<Certificate> getCertificatesTrustedForOcsp(String certificateName) {
        return this.ocspTrustedCertificates.getOrDefault(certificateName, Collections.emptySet());
    }

    public Set<Certificate> getCertificatesTrustedForCrl(String certificateName) {
        return this.crlTrustedCertificates.getOrDefault(certificateName, Collections.emptySet());
    }

    public Set<Certificate> getCertificatesTrustedForTimestamp(String certificateName) {
        return this.timestampTrustedCertificates.getOrDefault(certificateName, Collections.emptySet());
    }

    public Set<Certificate> getCertificatesTrustedForCA(String certificateName) {
        return this.caTrustedCertificates.getOrDefault(certificateName, Collections.emptySet());
    }

    public Set<Certificate> getKnownCertificates(String certificateName) {
        HashSet<Certificate> result = new HashSet<Certificate>();
        TrustedCertificatesStore.addMatched(result, this.generallyTrustedCertificates, certificateName);
        TrustedCertificatesStore.addMatched(result, this.ocspTrustedCertificates, certificateName);
        TrustedCertificatesStore.addMatched(result, this.crlTrustedCertificates, certificateName);
        TrustedCertificatesStore.addMatched(result, this.timestampTrustedCertificates, certificateName);
        TrustedCertificatesStore.addMatched(result, this.caTrustedCertificates, certificateName);
        return result;
    }

    public Collection<Certificate> getAllTrustedCertificates() {
        HashSet<Certificate> certificates = new HashSet<Certificate>();
        for (Set<Certificate> set : this.generallyTrustedCertificates.values()) {
            certificates.addAll(set);
        }
        for (Set<Certificate> set : this.ocspTrustedCertificates.values()) {
            certificates.addAll(set);
        }
        for (Set<Certificate> set : this.crlTrustedCertificates.values()) {
            certificates.addAll(set);
        }
        for (Set<Certificate> set : this.timestampTrustedCertificates.values()) {
            certificates.addAll(set);
        }
        for (Set<Certificate> set : this.caTrustedCertificates.values()) {
            certificates.addAll(set);
        }
        return certificates;
    }

    public Set<Certificate> getAllTrustedCertificates(String name) {
        HashSet<Certificate> certificates = new HashSet<Certificate>();
        Set<Certificate> set = this.generallyTrustedCertificates.get(name);
        if (set != null) {
            certificates.addAll(set);
        }
        if ((set = this.ocspTrustedCertificates.get(name)) != null) {
            certificates.addAll(set);
        }
        if ((set = this.crlTrustedCertificates.get(name)) != null) {
            certificates.addAll(set);
        }
        if ((set = this.timestampTrustedCertificates.get(name)) != null) {
            certificates.addAll(set);
        }
        if ((set = this.caTrustedCertificates.get(name)) != null) {
            certificates.addAll(set);
        }
        return certificates;
    }

    private static void addCertificateToMap(Certificate certificate, Map<String, Set<Certificate>> map) {
        String name = ((X509Certificate)certificate).getSubjectX500Principal().getName();
        Set set = map.computeIfAbsent(name, k -> new HashSet());
        set.add(certificate);
    }

    private static boolean mapContainsCertificate(Certificate certificate, Map<String, Set<Certificate>> map) {
        Set<Certificate> set = map.get(((X509Certificate)certificate).getSubjectX500Principal().getName());
        if (set == null) {
            return false;
        }
        return set.contains(certificate);
    }

    private static void addMatched(Set<Certificate> target, Map<String, Set<Certificate>> source, String certificateName) {
        Set<Certificate> subset = source.get(certificateName);
        if (subset != null) {
            target.addAll(subset);
        }
    }
}

