/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.tsp.ITimeStampToken;
import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.kernel.crypto.OID;
import com.itextpdf.signatures.SignUtils;
import com.itextpdf.signatures.VerificationException;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CertificateVerification {
    public static final String HAS_UNSUPPORTED_EXTENSIONS = "Has unsupported critical extension";
    public static final String CERTIFICATE_REVOKED = "Certificate revoked";
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateVerification.class);

    public static String verifyCertificate(X509Certificate cert, Collection<CRL> crls) {
        return CertificateVerification.verifyCertificate(cert, crls, DateTimeUtil.getCurrentTimeCalendar());
    }

    public static String verifyCertificate(X509Certificate cert, Collection<CRL> crls, Calendar calendar) {
        if (CertificateVerification.hasUnsupportedCriticalExtension(cert)) {
            return HAS_UNSUPPORTED_EXTENSIONS;
        }
        try {
            cert.checkValidity(calendar.getTime());
        }
        catch (Exception e) {
            return e.getMessage();
        }
        if (crls != null) {
            for (CRL crl : crls) {
                if (!crl.isRevoked(cert)) continue;
                return CERTIFICATE_REVOKED;
            }
        }
        return null;
    }

    public static List<VerificationException> verifyCertificates(Certificate[] certs, KeyStore keystore, Collection<CRL> crls) throws CertificateEncodingException {
        return CertificateVerification.verifyCertificates(certs, keystore, crls, DateTimeUtil.getCurrentTimeCalendar());
    }

    /*
     * Loose catch block
     */
    public static List<VerificationException> verifyCertificates(Certificate[] certs, KeyStore keystore, Collection<CRL> crls, Calendar calendar) throws CertificateEncodingException {
        ArrayList<VerificationException> result = new ArrayList<VerificationException>();
        for (int k = 0; k < certs.length; ++k) {
            int j;
            X509Certificate cert = (X509Certificate)certs[k];
            String err = CertificateVerification.verifyCertificate(cert, crls, calendar);
            if (err != null) {
                result.add(new VerificationException(cert, err));
            }
            try {
                for (X509Certificate certStoreX509 : SignUtils.getCertificates(keystore)) {
                    if (CertificateVerification.verifyCertificate(certStoreX509, crls, calendar) != null) continue;
                    {
                        catch (Exception exception) {}
                    }
                    try {
                        cert.verify(certStoreX509.getPublicKey());
                        return result;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (j = 0; j < certs.length; ++j) {
                if (j == k) continue;
                X509Certificate certNext = (X509Certificate)certs[j];
                try {
                    cert.verify(certNext.getPublicKey());
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (j != certs.length) continue;
            result.add(new VerificationException(cert, "Cannot be verified against the KeyStore or the certificate chain."));
        }
        if (result.size() == 0) {
            result.add(new VerificationException((Certificate)null, "Invalid state. Possible circular certificate chain."));
        }
        return result;
    }

    public static List<VerificationException> verifyCertificates(Certificate[] certs, KeyStore keystore) throws CertificateEncodingException {
        return CertificateVerification.verifyCertificates(certs, keystore, DateTimeUtil.getCurrentTimeCalendar());
    }

    public static List<VerificationException> verifyCertificates(Certificate[] certs, KeyStore keystore, Calendar calendar) throws CertificateEncodingException {
        return CertificateVerification.verifyCertificates(certs, keystore, null, calendar);
    }

    public static boolean verifyOcspCertificates(IBasicOCSPResp ocsp, KeyStore keystore, String provider) {
        ArrayList<Exception> exceptionsThrown = new ArrayList<Exception>();
        try {
            for (X509Certificate certStoreX509 : SignUtils.getCertificates(keystore)) {
                try {
                    if (!SignUtils.isSignatureValid(ocsp, (Certificate)certStoreX509, provider)) continue;
                    return true;
                }
                catch (Exception ex) {
                    exceptionsThrown.add(ex);
                }
            }
        }
        catch (Exception e) {
            exceptionsThrown.add(e);
        }
        CertificateVerification.logExceptionMessages(exceptionsThrown);
        return false;
    }

    public static boolean verifyTimestampCertificates(ITimeStampToken ts, KeyStore keystore, String provider) {
        ArrayList<Exception> exceptionsThrown = new ArrayList<Exception>();
        try {
            for (X509Certificate certStoreX509 : SignUtils.getCertificates(keystore)) {
                try {
                    SignUtils.isSignatureValid(ts, certStoreX509, provider);
                    return true;
                }
                catch (Exception ex) {
                    exceptionsThrown.add(ex);
                }
            }
        }
        catch (Exception e) {
            exceptionsThrown.add(e);
        }
        CertificateVerification.logExceptionMessages(exceptionsThrown);
        return false;
    }

    protected static boolean hasUnsupportedCriticalExtension(X509Certificate cert) {
        if (cert == null) {
            throw new IllegalArgumentException("X509Certificate can't be null.");
        }
        Set<String> criticalExtensionsSet = cert.getCriticalExtensionOIDs();
        if (criticalExtensionsSet != null) {
            for (String oid : criticalExtensionsSet) {
                if (OID.X509Extensions.SUPPORTED_CRITICAL_EXTENSIONS.contains(oid)) continue;
                return true;
            }
        }
        return false;
    }

    private static void logExceptionMessages(List<Exception> exceptionsThrown) {
        for (Exception ex : exceptionsThrown) {
            LOGGER.error(ex.getMessage() == null ? "Unexpected exception without message was thrown during keystore processing" : ex.getMessage(), (Throwable)ex);
        }
    }
}

