/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.IIssuingCertificateRetriever;
import com.itextpdf.signatures.SignUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuingCertificateRetriever
implements IIssuingCertificateRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssuingCertificateRetriever.class);
    private final Map<String, Certificate> certificateMap = new HashMap<String, Certificate>();

    @Override
    public Certificate[] retrieveMissingCertificates(Certificate[] chain) {
        ArrayList<Certificate> fullChain = new ArrayList<Certificate>();
        X509Certificate signingCertificate = (X509Certificate)chain[0];
        fullChain.add(signingCertificate);
        int i = 1;
        X509Certificate lastAddedCert = signingCertificate;
        while (!CertificateUtil.isSelfSigned(lastAddedCert)) {
            if (i < chain.length && CertificateUtil.isIssuerCertificate(lastAddedCert, (X509Certificate)chain[i])) {
                fullChain.add(chain[i]);
                ++i;
            } else {
                String url = CertificateUtil.getIssuerCertURL(lastAddedCert);
                Collection<Certificate> certificatesFromAIA = this.processCertificatesFromAIA(url);
                if (certificatesFromAIA == null || certificatesFromAIA.isEmpty()) {
                    Certificate issuer = this.certificateMap.get(lastAddedCert.getIssuerX500Principal().getName());
                    if (issuer == null) {
                        while (i < chain.length) {
                            fullChain.add(chain[i]);
                            ++i;
                        }
                        return fullChain.toArray(new Certificate[0]);
                    }
                    fullChain.add(issuer);
                } else {
                    fullChain.addAll(certificatesFromAIA);
                }
            }
            lastAddedCert = (X509Certificate)fullChain.get(fullChain.size() - 1);
        }
        return fullChain.toArray(new Certificate[0]);
    }

    @Override
    public Certificate[] getCrlIssuerCertificates(CRL crl) {
        String url = CertificateUtil.getIssuerCertURL(crl);
        List certificatesFromAIA = (List)this.processCertificatesFromAIA(url);
        if (certificatesFromAIA == null) {
            Certificate issuer = this.certificateMap.get(((X509CRL)crl).getIssuerX500Principal().getName());
            if (issuer == null) {
                return new Certificate[0];
            }
            return this.retrieveMissingCertificates(new Certificate[]{issuer});
        }
        return this.retrieveMissingCertificates(certificatesFromAIA.toArray(new Certificate[0]));
    }

    @Override
    public void setTrustedCertificates(Collection<Certificate> certificates) {
        for (Certificate certificate : certificates) {
            this.certificateMap.put(((X509Certificate)certificate).getSubjectX500Principal().getName(), certificate);
        }
    }

    protected InputStream getIssuerCertByURI(String uri) throws IOException {
        return SignUtils.getHttpResponse(new URL(uri));
    }

    protected Collection<Certificate> parseCertificates(InputStream certsData) throws CertificateException {
        return SignUtils.readAllCerts(certsData, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<Certificate> processCertificatesFromAIA(String url) {
        if (url == null) {
            return null;
        }
        try (InputStream missingCertsData = this.getIssuerCertByURI(url);){
            Collection<Certificate> collection = this.parseCertificates(missingCertsData);
            return collection;
        }
        catch (Exception e) {
            LOGGER.warn("Unable to parse certificates coming from authority info access extension. Those won't be included into the certificate chain.");
            return null;
        }
    }
}

