/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1InputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.IASN1OctetString;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Sequence;
import com.itextpdf.commons.bouncycastle.asn1.IASN1TaggedObject;
import com.itextpdf.commons.bouncycastle.asn1.IDERIA5String;
import com.itextpdf.commons.bouncycastle.asn1.IDEROctetString;
import com.itextpdf.commons.bouncycastle.asn1.x509.ICRLDistPoint;
import com.itextpdf.commons.bouncycastle.asn1.x509.IDistributionPoint;
import com.itextpdf.commons.bouncycastle.asn1.x509.IDistributionPointName;
import com.itextpdf.commons.bouncycastle.asn1.x509.IGeneralName;
import com.itextpdf.commons.bouncycastle.asn1.x509.IGeneralNames;
import com.itextpdf.signatures.SignUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class CertificateUtil {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();

    public static CRL getCRL(X509Certificate certificate) throws CertificateException, CRLException, IOException {
        return CertificateUtil.getCRL(CertificateUtil.getCRLURL(certificate));
    }

    public static String getCRLURL(X509Certificate certificate) {
        IDistributionPoint[] dists;
        IASN1Primitive obj;
        try {
            obj = CertificateUtil.getExtensionValue(certificate, FACTORY.createExtension().getCRlDistributionPoints().getId());
        }
        catch (IOException e) {
            obj = null;
        }
        if (obj == null) {
            return null;
        }
        ICRLDistPoint dist = FACTORY.createCRLDistPoint((Object)obj);
        for (IDistributionPoint p : dists = dist.getDistributionPoints()) {
            IGeneralName[] names;
            IDistributionPointName distributionPointName = p.getDistributionPoint();
            if (FACTORY.createDistributionPointName().getFullName() != distributionPointName.getType()) continue;
            IGeneralNames generalNames = FACTORY.createGeneralNames(distributionPointName.getName());
            for (IGeneralName name : names = generalNames.getNames()) {
                if (name.getTagNo() != FACTORY.createGeneralName().getUniformResourceIdentifier()) continue;
                IDERIA5String derStr = FACTORY.createDERIA5String(FACTORY.createASN1TaggedObject((IASN1Encodable)name.toASN1Primitive()), false);
                return derStr.getString();
            }
        }
        return null;
    }

    public static CRL getCRL(String url) throws IOException, CertificateException, CRLException {
        if (url == null) {
            return null;
        }
        return SignUtils.parseCrlFromStream(new URL(url).openStream());
    }

    public static String getOCSPURL(X509Certificate certificate) {
        try {
            IASN1Primitive obj = CertificateUtil.getExtensionValue(certificate, FACTORY.createExtension().getAuthorityInfoAccess().getId());
            if (obj == null) {
                return null;
            }
            IASN1Sequence accessDescriptions = FACTORY.createASN1Sequence((IASN1Encodable)obj);
            for (int i = 0; i < accessDescriptions.size(); ++i) {
                IASN1Sequence accessDescription = FACTORY.createASN1Sequence(accessDescriptions.getObjectAt(i));
                IASN1ObjectIdentifier id = FACTORY.createASN1ObjectIdentifier(accessDescription.getObjectAt(0));
                if (accessDescription.size() != 2 || id == null || !"1.3.6.1.5.5.7.48.1".equals(id.getId())) continue;
                IASN1Primitive description = FACTORY.createASN1Primitive(accessDescription.getObjectAt(1));
                return CertificateUtil.getStringFromGeneralName(description);
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public static String getTSAURL(X509Certificate certificate) {
        byte[] der = SignUtils.getExtensionValueByOid(certificate, "1.2.840.113583.1.1.9.1");
        if (der == null) {
            return null;
        }
        try {
            IASN1Primitive asn1obj = FACTORY.createASN1Primitive(der);
            IDEROctetString octets = FACTORY.createDEROctetString((IASN1Encodable)asn1obj);
            asn1obj = FACTORY.createASN1Primitive(octets.getOctets());
            IASN1Sequence asn1seq = FACTORY.createASN1SequenceInstance((Object)asn1obj);
            return CertificateUtil.getStringFromGeneralName(asn1seq.getObjectAt(1).toASN1Primitive());
        }
        catch (IOException e) {
            return null;
        }
    }

    private static IASN1Primitive getExtensionValue(X509Certificate certificate, String oid) throws IOException {
        IASN1OctetString octs;
        byte[] bytes = SignUtils.getExtensionValueByOid(certificate, oid);
        if (bytes == null) {
            return null;
        }
        try (IASN1InputStream aIn = FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(bytes));){
            octs = FACTORY.createASN1OctetString((IASN1Encodable)aIn.readObject());
        }
        aIn = FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(octs.getOctets()));
        var5_4 = null;
        try {
            IASN1Primitive iASN1Primitive = aIn.readObject();
            return iASN1Primitive;
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (aIn != null) {
                if (var5_4 != null) {
                    try {
                        aIn.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    aIn.close();
                }
            }
        }
    }

    private static String getStringFromGeneralName(IASN1Primitive names) {
        IASN1TaggedObject taggedObject = FACTORY.createASN1TaggedObject((IASN1Encodable)names);
        return new String(FACTORY.createASN1OctetString(taggedObject, false).getOctets(), StandardCharsets.ISO_8859_1);
    }
}

