/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.RASInputStream;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.io.source.WindowRandomAccessSource;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDate;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.signatures.PdfPKCS7;
import com.itextpdf.signatures.PdfSignature;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SignatureUtil {
    private PdfDocument document;
    private PdfAcroForm acroForm;
    private Map<String, int[]> sigNames;
    private List<String> orderedSignatureNames;
    private int totalRevisions;

    public SignatureUtil(PdfDocument document) {
        this.document = document;
        this.acroForm = PdfAcroForm.getAcroForm((PdfDocument)document, (boolean)true);
    }

    public PdfPKCS7 verifySignature(String name) {
        return this.verifySignature(name, null);
    }

    public PdfPKCS7 verifySignature(String name, String provider) {
        PdfSignature signature = this.getSignature(name);
        if (signature == null) {
            return null;
        }
        try {
            String location;
            PdfName sub = signature.getSubFilter();
            PdfString contents = signature.getContents();
            PdfPKCS7 pk = null;
            if (sub.equals((Object)PdfName.Adbe_x509_rsa_sha1)) {
                PdfString cert = ((PdfDictionary)signature.getPdfObject()).getAsString(PdfName.Cert);
                if (cert == null) {
                    cert = ((PdfDictionary)signature.getPdfObject()).getAsArray(PdfName.Cert).getAsString(0);
                }
                pk = new PdfPKCS7(PdfEncodings.convertToBytes((String)contents.getValue(), null), cert.getValueBytes(), provider);
            } else {
                pk = new PdfPKCS7(PdfEncodings.convertToBytes((String)contents.getValue(), null), sub, provider);
            }
            this.updateByteRange(pk, signature);
            PdfString date = signature.getDate();
            if (date != null) {
                pk.setSignDate(PdfDate.decode((String)date.toString()));
            }
            String signName = signature.getName();
            pk.setSignName(signName);
            String reason = signature.getReason();
            if (reason != null) {
                pk.setReason(reason);
            }
            if ((location = signature.getLocation()) != null) {
                pk.setLocation(location);
            }
            return pk;
        }
        catch (Exception e) {
            throw new PdfException((Throwable)e);
        }
    }

    public PdfSignature getSignature(String name) {
        PdfDictionary sigDict = this.getSignatureDictionary(name);
        return sigDict != null ? new PdfSignature(sigDict) : null;
    }

    public PdfDictionary getSignatureDictionary(String name) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(name)) {
            return null;
        }
        PdfFormField field = this.acroForm.getField(name);
        PdfDictionary merged = (PdfDictionary)field.getPdfObject();
        return merged.getAsDictionary(PdfName.V);
    }

    private void updateByteRange(PdfPKCS7 pkcs7, PdfSignature signature) {
        PdfArray b = signature.getByteRange();
        RandomAccessFileOrArray rf = this.document.getReader().getSafeFile();
        InputStream rg = null;
        try {
            int rd;
            rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(rf.createSourceView(), SignatureUtil.asLongArray(b)));
            byte[] buf = new byte[8192];
            while ((rd = rg.read(buf, 0, buf.length)) > 0) {
                pkcs7.update(buf, 0, rd);
            }
        }
        catch (Exception e) {
            throw new PdfException((Throwable)e);
        }
        finally {
            try {
                if (rg != null) {
                    rg.close();
                }
            }
            catch (IOException e) {
                throw new PdfException((Throwable)e);
            }
        }
    }

    public List<String> getSignatureNames() {
        if (this.sigNames != null) {
            return new ArrayList<String>(this.orderedSignatureNames);
        }
        this.sigNames = new HashMap<String, int[]>();
        this.orderedSignatureNames = new ArrayList<String>();
        ArrayList<Object[]> sorter = new ArrayList<Object[]>();
        for (Map.Entry entry : this.acroForm.getFormFields().entrySet()) {
            int rangeSize;
            PdfString contents;
            PdfDictionary v;
            PdfFormField field = (PdfFormField)entry.getValue();
            PdfDictionary merged = (PdfDictionary)field.getPdfObject();
            if (!PdfName.Sig.equals((Object)merged.get(PdfName.FT)) || (v = merged.getAsDictionary(PdfName.V)) == null || (contents = v.getAsString(PdfName.Contents)) == null) continue;
            contents.markAsUnencryptedObject();
            PdfArray ro = v.getAsArray(PdfName.ByteRange);
            if (ro == null || (rangeSize = ro.size()) < 2) continue;
            int length = ro.getAsNumber(rangeSize - 1).intValue() + ro.getAsNumber(rangeSize - 2).intValue();
            sorter.add(new Object[]{entry.getKey(), new int[]{length, 0}});
        }
        Collections.sort(sorter, new SorterComparator());
        if (sorter.size() > 0) {
            try {
                this.totalRevisions = (long)((int[])((Object[])sorter.get(sorter.size() - 1))[1])[0] == this.document.getReader().getFileLength() ? sorter.size() : sorter.size() + 1;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (int k = 0; k < sorter.size(); ++k) {
                Object[] objs = (Object[])sorter.get(k);
                String name = (String)objs[0];
                int[] p = (int[])objs[1];
                p[1] = k + 1;
                this.sigNames.put(name, p);
                this.orderedSignatureNames.add(name);
            }
        }
        return new ArrayList<String>(this.orderedSignatureNames);
    }

    public List<String> getBlankSignatureNames() {
        this.getSignatureNames();
        ArrayList<String> sigs = new ArrayList<String>();
        for (Map.Entry entry : this.acroForm.getFormFields().entrySet()) {
            PdfFormField field = (PdfFormField)entry.getValue();
            PdfDictionary merged = (PdfDictionary)field.getPdfObject();
            if (!PdfName.Sig.equals((Object)merged.getAsName(PdfName.FT)) || this.sigNames.containsKey(entry.getKey())) continue;
            sigs.add((String)entry.getKey());
        }
        return sigs;
    }

    public int getTotalRevisions() {
        this.getSignatureNames();
        return this.totalRevisions;
    }

    public int getRevision(String field) {
        this.getSignatureNames();
        field = this.getTranslatedFieldName(field);
        if (!this.sigNames.containsKey(field)) {
            return 0;
        }
        return this.sigNames.get(field)[1];
    }

    public String getTranslatedFieldName(String name) {
        String namex;
        if (this.acroForm.getXfaForm().isXfaPresent() && (namex = this.acroForm.getXfaForm().findFieldName(name)) != null) {
            name = namex;
        }
        return name;
    }

    public InputStream extractRevision(String field) throws IOException {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(field)) {
            return null;
        }
        int length = this.sigNames.get(field)[0];
        RandomAccessFileOrArray raf = this.document.getReader().getSafeFile();
        return new RASInputStream((IRandomAccessSource)new WindowRandomAccessSource(raf.createSourceView(), 0L, (long)length));
    }

    public boolean signatureCoversWholeDocument(String name) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(name)) {
            return false;
        }
        try {
            return (long)this.sigNames.get(name)[0] == this.document.getReader().getFileLength();
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
    }

    public boolean doesSignatureFieldExist(String name) {
        return this.getBlankSignatureNames().contains(name) || this.getSignatureNames().contains(name);
    }

    public static long[] asLongArray(PdfArray pdfArray) {
        long[] rslt = new long[pdfArray.size()];
        for (int k = 0; k < rslt.length; ++k) {
            rslt[k] = pdfArray.getAsNumber(k).longValue();
        }
        return rslt;
    }

    private static class SorterComparator
    implements Comparator<Object[]> {
        private SorterComparator() {
        }

        @Override
        public int compare(Object[] o1, Object[] o2) {
            int n1 = ((int[])o1[1])[0];
            int n2 = ((int[])o2[1])[0];
            return n1 - n2;
        }
    }
}

